<?php

/*
|--------------------------------------------------------------------------
| Web Routes
|--------------------------------------------------------------------------
|
| Here is where you can register web routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| contains the "web" middleware group. Now create something great!
|
*/

use App\Http\Controllers\AboutAppConfigurationController;
use App\Http\Controllers\AdsConfigurationController;
use App\Http\Controllers\AppConfigurationController;
use App\Http\Controllers\BottomNavigationStyleController;
use App\Http\Controllers\DashboardController;
use App\Http\Controllers\ExitPopupConfigurationController;
use App\Http\Controllers\ThemeStyleController;
use App\Http\Controllers\FloatingButtonController;
use App\Http\Controllers\LeftHeaderNavigationController;
use App\Http\Controllers\OneSignalConfigurationController;
use App\Http\Controllers\OneSignalSendController;
use App\Http\Controllers\PagesController;
use App\Http\Controllers\ProgressBarController;
use App\Http\Controllers\RightHeaderNavigationController;
use App\Http\Controllers\ShareContentController;
use App\Http\Controllers\SplashConfigurationController;
use App\Http\Controllers\UserAgentController;
use App\Http\Controllers\WalkThrouguController;
use App\Http\Controllers\UserController;
use Illuminate\Support\Facades\Redirect;
use Illuminate\Support\Facades\Route;

/*
|--------------------------------------------------------------------------
| Web Routes
|--------------------------------------------------------------------------
|
| Here is where you can register web routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| contains the "web" middleware group. Now create something great!
|
*/

Route::get('/', function () {
    return \redirect(\route('login'));
})->name('home');

Route::get('/login', function () {
    return (! Auth::check()) ? view('auth.login') : Redirect::to(getDashboardURL());
})->name('login');

Route::group([
    'prefix' => 'admin', 'middleware' => ['auth', 'xss'],
], function () {
    Route::get('dashboard', [DashboardController::class, 'index'])->name('admin.dashboard');
    Route::get('/profile/edit', [UserController::class, 'editProfile'])->name('profile.setting');
    Route::put('/profile/update', [UserController::class, 'updateProfile'])->name('update.profile.setting');
    Route::get('app-configurations', [AppConfigurationController::class, 'index'])->name('app.configuration.index');
    Route::get('theme-style', [ThemeStyleController::class, 'index'])->name('theme.style.index');
    Route::post('theme-style', [ThemeStyleController::class, 'store'])->name('theme.style.store');
    Route::post('app-configurations', [AppConfigurationController::class, 'update'])->name('app.configuration.update');
//    Route::get('ads-configurations', [AdsConfigurationController::class, 'index'])->name('ads.configuration.index');
//    Route::post('ads-configurations', [AdsConfigurationController::class, 'update'])->name('ads.configuration.update');
    Route::get('progress-bars', [ProgressBarController::class, 'index'])->name('progressbar.index');
    Route::post('progress-bars', [ProgressBarController::class, 'update'])->name('progressbar.update');
    Route::resource('bottom-navigation-style', BottomNavigationStyleController::class)->except('update');
    Route::post('bottom-navigation-style/{bottom_navigation_style}',
        [BottomNavigationStyleController::class, 'update'])->name('bottom-navigation-style.update');
    Route::put('bottom-nav-status',
        [BottomNavigationStyleController::class, 'changeBottomNavStatus'])->name('bottom.nav.status');
    Route::resource('splash-configuration', SplashConfigurationController::class);

    Route::resource('floating-button', FloatingButtonController::class);
    Route::put('floating-button-status',
        [FloatingButtonController::class, 'changeBottomNavStatus'])->name('floating.button.status');

    Route::get('about-app-configurations',
        [AboutAppConfigurationController::class, 'index'])->name('about.app.configuration.index');
    Route::post('about-app-configurations',
        [AboutAppConfigurationController::class, 'update'])->name('about.app.configuration.update');
    Route::get('about-app-configurations',
        [AboutAppConfigurationController::class, 'index'])->name('about.app.configuration.index');
    Route::post('about-app-configurations',
        [AboutAppConfigurationController::class, 'update'])->name('about.app.configuration.update');
    Route::resource('walk-through', WalkThrouguController::class);
//    Route::resource('pages', PagesController::class);

    Route::put('walk-through-status',
        [WalkThrouguController::class, 'changeWalkThroughStatus'])->name('walk.Through.status');
//    Route::put('pages-status', [PagesController::class, 'changePagesStatus'])->name('pages.status');
    Route::get('left-header-navigations',
        [LeftHeaderNavigationController::class, 'index'])->name('left.header.navigation.index');
    Route::post('left-header-navigations/{leftHeaderNavigation}/enable-disable',
        [LeftHeaderNavigationController::class, 'enableDisable'])->name('left.header.navigation.enable.disable');
    Route::post('left-header-navigations/{leftHeaderNavigation}/change-status',
        [LeftHeaderNavigationController::class, 'changeStatus'])->name('left.header.navigation.change.status');
    Route::get('left-header-navigations/{leftHeaderNavigation}/change-url',
        [LeftHeaderNavigationController::class, 'changeUrledit'])->name('left.header.navigation.change-url');
    Route::post('left-header-navigations/{leftHeaderNavigation}/update-url',
        [LeftHeaderNavigationController::class, 'updateUrl'])->name('left.header.navigation.update.url');
    Route::get('right-header-navigations',
        [RightHeaderNavigationController::class, 'index'])->name('right.header.navigation.index');
    Route::post('right-header-navigations/{rightHeaderNavigation}/enable-disable',
        [RightHeaderNavigationController::class, 'enableDisable'])->name('right.header.navigation.enable.disable');
    Route::post('right-header-navigations/{rightHeaderNavigation}/change-status',
        [RightHeaderNavigationController::class, 'changeStatus'])->name('right.header.navigation.change.status');
    Route::get('right-header-navigations/{rightHeaderNavigation}/change-url',
        [RightHeaderNavigationController::class, 'changeUrledit'])->name('right.header.navigation.change-url');
    Route::post('right-header-navigations/{rightHeaderNavigation}/update-url',
        [RightHeaderNavigationController::class, 'updateUrl'])->name('right.header.navigation.update.url');
    Route::post('change-password', [UserController::class, 'changePassword'])->name('change-password');

//    Route::resource('useragent', UserAgentController::class);
    Route::get('share-content', [ShareContentController::class, 'index'])->name('share-content.index');
    Route::post('share-content', [ShareContentController::class, 'store'])->name('share-content.store');
    Route::get('right-header-navigations',
        [RightHeaderNavigationController::class, 'index'])->name('right.header.navigation.index');
    Route::post('right-header-navigations/{rightHeaderNavigation}/enable-disable',
        [RightHeaderNavigationController::class, 'enableDisable'])->name('right.header.navigation.enable.disable');
    Route::post('right-header-navigations/{rightHeaderNavigation}/change-status',
        [RightHeaderNavigationController::class, 'changeStatus'])->name('right.header.navigation.change.status');
    Route::get('right-header-navigations/{rightHeaderNavigation}/change-url',
        [RightHeaderNavigationController::class, 'changeUrledit'])->name('right.header.navigation.change-url');
    Route::post('right-header-navigations/{rightHeaderNavigation}/update-url',
        [RightHeaderNavigationController::class, 'updateUrl'])->name('right.header.navigation.update.url');

    Route::resource('onesignal-configuration', OneSignalConfigurationController::class);
    Route::resource('onesignal-send', OneSignalSendController::class);
    Route::resource('exitpopup-configuration', ExitPopupConfigurationController::class);
    
});
require __DIR__.'/auth.php';
