@extends('layouts.app')
@section('title')
    Theme-Style
@endsection
@section('content')
    <div class="container-fluid">
        <div class="row">
            <div class="col-xl-12 col-lg-12">
                <div class="card">
                    <div class="card-body">
                        @include('flash::message')
                        @if ($errors->any())
                            <div class="alert alert-danger">{{ $errors->first() }}</div>
                        @endif
                        @include('flash::message')
                        <form method="post" action="{{ route('theme.style.store') }}">
                                <div class="row">
                                    <div class="mb-5 col-md-4">
                                        <h5 class="form-check-label">Gradient Enable</h5>
                                        <div class="form-group d-flex">
                                            <div class="form-check">
                                                <input class="form-check-input" type="radio" name="gradient_enable"
                                                       id="gradientEnable1"
                                                       value="1" {{ ($themeStyleData['gradient_enable']) == 1 ? 'checked' : '' }}>
                                                <label class="form-check-label" for="requiredProgressBar1">Yes</label>
                                            </div>
                                            <div class="form-check ms-3">
                                                <input class="form-check-input" type="radio" name="gradient_enable"
                                                       id="gradientEnable2"
                                                       value="0" {{ ($themeStyleData['gradient_enable']) == 0 ? 'checked' : '' }}>
                                                <label class="form-check-label" for="requiredProgressBar2">No</label>
                                            </div>
                                        </div>
                                    </div>
                                </div>

                            <div class="gradientDisable">
                                <div class="row">
                                    {{ $colorExist = false}}
                                    {{ $colorGradientExist = false  }}

                                    @foreach(App\Models\ThemeStyle::THEME as $color => $value)
                                        @php
                                            if ($themeStyleData['theme_style'] == $color){
                                            $colorExist = true;
                                            }
                                        @endphp
                                        @php
                                            if(isset(explode(',',$themeStyleData['theme_style'])[1])){
                                              $colorGradientExist= true;
                                              }
                                        @endphp
                                        <div class="form-group col-md-4 mb-4">
                                            <div class="d-flex justify-content-between">
                                                <div class="form-radio d-inline">
                                                    <input type="radio" name="themeStyle" id="default-{{$color}}"
                                                           value="{{$color}}"
                                                           class="form-check-input default_theme"
                                                            {{$themeStyleData['theme_style'] == $color ? 'checked' : ''}}>
                                                    <label class="form-check-label"
                                                           for="default-{{$color}}">{{$value}}</label>
                                                </div>
                                                <div class="top-block-one d-flex align-items-center justify-content-between">
                                                    <div class="icon avatar-40 mx-4 rounded"
                                                         style="background-color: {{$color}};"></div>
                                                </div>
                                            </div>
                                        </div>
                                    @endforeach
                                </div>
                                <div class="row">
                                    <div class="form-group col-md-4 mb-4">
                                        <div class="d-flex justify-content-between">
                                            <div class="form-radio d-inline">
                                                <input type="radio" name="themeStyle" id="radioCustom"
                                                       value="{{$themeStyleData['theme_style']}}"
                                                       class="custom form-check-input" {{ !$colorExist? 'checked' : '' }}>
                                                <label class="form-check-label" for="radioCustom">Custom Color
                                                    Theme</label>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                <div class="row mb-4 d-none custom_color_theme">
                                    <div class="form-group col-md-4">
                                        <label for="customColor">Custom Color </label>
                                        <input type="color" name="customColor" class="form-control customColor"
                                               id="customColor" value="{{$themeStyleData['theme_style']}}">
                                    </div>
                                </div>
                            </div>
                            <div class="gradientEnable">
                                <div class="row">
                                    <div class="form-group col-md-4 mb-4">
                                        <div class="d-flex justify-content-between">
                                            <div class="form-radio d-inline">
                                                <input type="radio" name="themeStyle" id="radioGradient" value=""
                                                       class="gradient form-check-input" {{ $colorGradientExist? 'checked' : '' }}>
                                                <label class="form-check-label" for="radioGradient">Gradient Color
                                                    Theme</label>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                <div class="row d-none gradient_color_theme">
                                    <div class="col-md-6">
                                        <div class="form-group mb-4">
                                            <label for="gradientColor1">Gradient Color 1</label>
                                            <input type="color" name="gradientColor1" class="form-control gradientColor"
                                                   id="gradientColor1"
                                                   value="{{explode(',',$themeStyleData['theme_style'])[0]}}">
                                        </div>
                                        <div class="form-group mb-4">
                                            <label for="gradientColor2">Gradient Color 2</label>
                                            <input type="color" name="gradientColor2" class="form-control gradientColor"
                                                   id="gradientColor2"
                                                   value="{{isset(explode(',',$themeStyleData['theme_style'])[1]) ? trim(explode(',',$themeStyleData['theme_style'])[1]) : explode(',',$themeStyleData['theme_style'])[0]}}">
                                        </div>
                                    </div>
                                    <div class="col-md-6 mb-4">
                                        <label for="preview" class="mb-3">Preview</label>
                                        <p class="pt-14 pb-4 text-center rounded preview_gradient"
                                           id="previewGradient"></p>
                                    </div>
                                </div>
                            </div>
                            <div class="d-flex mt-3">
                                <button type="submit" class="btn btn-primary me-5">Save</button>
                                <button type="button" class="btn btn-secondary">Cancel</button>
                            </div>
                        </form>
                    </form>
                </div>
            </div>
        </div>
    </div>
@endsection
