@extends('layouts.app')
@section('title')
    Share-Content
@endsection
@section('content')
    <div class="container-fluid">
        <div class="card">
            <div class="card-body">
                @include('flash::message')
                @if ($errors->any())
                    <div class="alert alert-danger">{{ $errors->first() }}</div>
                @endif
                @include('flash::message')
                <form method="post" action="{{ route('share-content.store') }}">
                    <div class="row">
                        <div class="form-group col-md-12 mb-3">
                            <label for="shareContent" class="mb-3">Share Content<span
                                        class="text-danger">*</span></label>
                            <textarea class="form-control" id="content" name="content"
                                      placeholder="Enter share content" rows="10"
                                      required="">{{ !empty($shareContentData['content']) ? $shareContentData['content'] : '' }}</textarea>
                        </div>
                    </div>
                    <div class="d-flex mt-3">
                        <button type="submit" class="btn btn-primary me-5">Save</button>
                        <button type="button" class="btn btn-secondary">Cancel</button>
                    </div>
                </form>
            </div>
        </div>
    </div>
@endsection
