@extends('layouts.app')
@section('title')
    ProgressBar-Style
@endsection
@section('content')
    <div class="container-fluid">
        <div class="d-flex flex-column">
            <div class="card">
                <div class="card-body">
                    @include('flash::message')
                    @if ($errors->any())
                        <div class="alert alert-danger">{{ $errors->first() }}</div>
                    @endif
                    {{ Form::open(['route' => 'progressbar.update', 'method' => 'post','id' => 'progressBarForm','files' => true]) }}
                        @csrf
                        <div class="row">
                            <div class="mb-5 col-md-4">
                                <h5 class="form-check-label">Required ProgressBar?</h5>
                                <div class="form-group d-flex">
                                    <div class="form-check">
                                        <input class="form-check-input" type="radio" name="progress_bar_required"
                                               id="requiredProgressBar1" value="1" {{ ($progressBar['progress_bar_required']) == 1 ? 'checked' : ''  }}>
                                        <label class="form-check-label" for="requiredProgressBar1">Yes</label>
                                    </div>
                                    <div class="form-check ms-3">
                                        <input class="form-check-input" type="radio" name="progress_bar_required"
                                               id="requiredProgressBar2" value="0" {{ ($progressBar['progress_bar_required']) == 0 ? 'checked' : ''  }}>
                                        <label class="form-check-label" for="requiredProgressBar2">No</label>
                                    </div>
                                </div>
                            </div>
                            <div class="row progressbar-art_style-block mb-4" id="requiredProgressBar">
                                <div class="form-group col-md-4 progressbar-art_style mt-5">
                                    <div class="form-check col-md-2 mb-3">
                                        <input type="radio" name="loader_style" id="progressLoader0" value="RotatingPlane" class="form-check-input" {{ ($progressBar['loader_style']) == \App\Models\ProgressBar::ROTATING_PLANE ? 'checked' : ''  }}>
                                        <label class="custom-control-label" for="progressLoader0">RotatingPlane</label>
                                    </div>
                                    <div class="progress-bar-avatar col-md-2">
                                        <img class="progress-bar-40 rounded" src="{{asset('images/art/RotatingPlane.gif')}}" alt="#">
                                    </div>
                                </div>
                                <div class="form-group col-md-4 progressbar-art_style mt-5">
                                    <div class="form-check col-md-2 mb-3">
                                        <input type="radio" name="loader_style" id="progressLoader1" value="DoubleBounce" class="form-check-input" {{ ($progressBar['loader_style']) == \App\Models\ProgressBar::DOUBLE_BOUNCE ? 'checked' : ''  }}>
                                        <label class="custom-control-label" for="progressLoader1">DoubleBounce</label>
                                    </div>
                                    <div class="progress-bar-avatar col-md-2">
                                        <img class="progress-bar-40 rounded" src="{{asset('images/art/DoubleBounce.gif')}}" alt="#">
                                    </div>
                                </div>
                                <div class="form-group col-md-4 progressbar-art_style mt-5">
                                    <div class="form-check col-md-2 mb-3">
                                        <input type="radio" name="loader_style" id="progressLoader2" value="WanderingCubes" class="form-check-input" {{ ($progressBar['loader_style']) == \App\Models\ProgressBar::WANDERING_CUBES ? 'checked' : ''  }}>
                                        <label class="custom-control-label" for="progressLoader2">WanderingCubes</label>
                                    </div>
                                    <div class="progress-bar-avatar col-md-2">
                                        <img class="progress-bar-40 rounded" src="{{asset('images/art/WanderingCubes.gif')}}" alt="#">
                                    </div>
                                </div>
                                <div class="form-group col-md-4 progressbar-art_style mt-5">
                                    <div class="form-check col-md-2 mb-3">
                                        <input type="radio" name="loader_style" id="progressLoader3" value="Pulse" class="form-check-input" {{ ($progressBar['loader_style']) == \App\Models\ProgressBar::PULSE ? 'checked' : ''  }}>
                                        <label class="custom-control-label" for="progressLoader3">Pulse</label>
                                    </div>
                                    <div class="progress-bar-avatar col-md-2">
                                        <img class="progress-bar-40 rounded" src="{{asset('images/art/Pulse.gif')}}" alt="#">
                                    </div>
                                </div>
                                <div class="form-group col-md-4 progressbar-art_style mt-5">
                                    <div class="form-check col-md-2 mb-3">
                                        <input type="radio" name="loader_style" id="progressLoader4" value="ChasingDots" class="form-check-input" {{ ($progressBar['loader_style']) == \App\Models\ProgressBar::CHASING_DOTS ? 'checked' : ''  }}>
                                        <label class="custom-control-label" for="progressLoader4">ChasingDots</label>
                                    </div>
                                    <div class="progress-bar-avatar col-md-2">
                                        <img class="progress-bar-40 rounded" src="{{asset('images/art/ChasingDots.gif')}}" alt="#">
                                    </div>
                                </div>
                                <div class="form-group col-md-4 progressbar-art_style mt-5">
                                    <div class="form-check col-md-2 mb-3">
                                        <input type="radio" name="loader_style" id="progressLoader5" value="FadingFour" class="form-check-input" {{ ($progressBar['loader_style']) == \App\Models\ProgressBar::FADING_FOUR ? 'checked' : ''  }}>
                                        <label class="custom-control-label" for="progressLoader5">FadingFour</label>
                                    </div>
                                    <div class="progress-bar-avatar col-md-2">
                                        <img class="progress-bar-40 rounded" src="{{asset('images/art/FadingFour.gif')}}" alt="#" >
                                    </div>
                                </div>
                                <div class="form-group col-md-4 progressbar-art_style mt-5">
                                    <div class="form-check col-md-2 mb-3">
                                        <input type="radio" name="loader_style" id="progressLoader6" value="Circle" class="form-check-input" {{ ($progressBar['loader_style']) == \App\Models\ProgressBar::CIRCLE ? 'checked' : ''  }}>
                                        <label class="custom-control-label" for="progressLoader6">Circle</label>
                                    </div>
                                    <div class="progress-bar-avatar col-md-2">
                                        <img class="progress-bar-40 rounded" src="{{asset('images/art/Circle.gif')}}" alt="#" >
                                    </div>
                                </div>
                                <div class="form-group col-md-4 progressbar-art_style mt-5">
                                    <div class="form-check col-md-2 mb-3">
                                        <input type="radio" name="loader_style" id="progressLoader7" value="FadingCircle" class="form-check-input" {{ ($progressBar['loader_style']) == \App\Models\ProgressBar::FADING_CIRCLE ? 'checked' : ''  }}>
                                        <label class="custom-control-label" for="progressLoader7">FadingCircle</label>
                                    </div>
                                    <div class="progress-bar-avatar col-md-2">
                                        <img class="progress-bar-40 rounded" src="{{asset('images/art/FadingCircle.gif')}}" alt="#">
                                    </div>
                                </div>
                                <div class="form-group col-md-4 progressbar-art_style mt-5">
                                    <div class="form-check col-md-2 mb-3">
                                        <input type="radio" name="loader_style" id="progressLoader8" value="FoldingCube" class="form-check-input" {{ ($progressBar['loader_style']) == \App\Models\ProgressBar::FOLDING_CUBE ? 'checked' : ''  }}>
                                        <label class="custom-control-label" for="progressLoader8">FoldingCube</label>
                                    </div>
                                    <div class="progress-bar-avatar col-md-2">
                                        <img class="progress-bar-40 rounded" src="{{asset('images/art/FoldingCube.gif')}}" alt="#">
                                    </div>
                                </div>
                                <div class="form-group col-md-4 progressbar-art_style mt-5">
                                    <div class="form-check col-md-2 mb-3">
                                        <input type="radio" name="loader_style" id="progressLoader9" value="RotatingCircle" class="form-check-input" {{ ($progressBar['loader_style']) == \App\Models\ProgressBar::ROTATING_CIRCLE ? 'checked' : ''  }}>
                                        <label class="custom-control-label" for="progressLoader9">RotatingCircle</label>
                                    </div>
                                    <div class="progress-bar-avatar col-md-2">
                                        <img class="progress-bar-40 rounded" src="{{asset('images/art/RotatingCircle.gif')}}" alt="#">
                                    </div>
                                </div>
                                <div class="form-group col-md-4 progressbar-art_style mt-5">
                                    <div class="form-check col-md-2 mb-3">
                                        <input type="radio" name="loader_style" id="progressLoader10" value="Wave" class="form-check-input" {{ ($progressBar['loader_style']) == \App\Models\ProgressBar::WAVE ? 'checked' : ''  }}>
                                        <label class="custom-control-label" for="progressLoader10">Wave</label>
                                    </div>
                                    <div class="progress-bar-avatar col-md-2">
                                        <img class="progress-bar-40 rounded" src="{{asset('images/art/Wave.gif')}}" alt="#">
                                    </div>
                                </div>
                                <div class="form-group col-md-4 progressbar-art_style mt-5">
                                    <div class="form-check col-md-2 mb-3">
                                        <input type="radio" name="loader_style" id="progressLoader11" value="Ring" class="form-check-input" {{ ($progressBar['loader_style']) == \App\Models\ProgressBar::RING ? 'checked' : ''  }}>
                                        <label class="custom-control-label" for="progressLoader11">Ring</label>
                                    </div>
                                    <div class="progress-bar-avatar col-md-2">
                                        <img class="progress-bar-40 rounded" src="{{asset('images/art/Ring.gif')}}" alt="#">
                                    </div>
                                </div>
                            </div>
                        <div class="float-end mt-5">
                            <button type="submit" class="btn btn-primary me-5">Save</button>
                            <button type="button" class="btn btn-secondary">Cancel</button>
                        </div>
                        </div>
                    {{ Form::close() }}
                </div>
            </div>
        </div>
    </div>
@endsection
