@extends('layouts.app')
@section('title')
    Onesignal-Send
@endsection
@section('content')
    <div class="container-fluid">
        @include('layouts.errors')
        <div class="row">
            <div class="col-xl-12 col-lg-12">
                <div class="card">
                    <div class="card-body">
                        <div class="new-user-info">
                            <form method="post" enctype="multipart/form-data"
                                  action="{{ route('onesignal-send.store') }}">
                                @csrf
                                <div class="row">
                                    <div class="form-group col-md-6 mb-3">
                                        <label for="title" class="mb-3">Title <span class="text-danger">*</span></label>
                                        <input type="text" class="form-control" name="title" value="{{ old('title') }}"
                                               placeholder="Enter title" required="">
                                    </div>
                                    <div class="form-group col-md-6 mb-3">
                                        <label for="message" class="mb-3">Message <span
                                                    class="text-danger">*</span></label>
                                        <textarea class="form-control" id="message" name="message" value=""
                                                  placeholder="Enter message" rows="2" required="">{{ old('message') }}</textarea>
                                    </div>
                                    <div class="form-group col-md-6 mb-3" io-image-input="true">
                                        <label for="exampleInputImage" class="form-label">Image:</label>
                                        <div class="d-block">
                                            <div class="image-picker">
                                                <div class="image previewImage" id="walkThoughPreviewImage"
                                                     style="background-image: url('{{asset('images/avatar.png') }}')"></div>
                                                <span class="picker-edit rounded-circle text-gray-500 fs-small"
                                                      title="edit">
                                    <label>
                                    <i class="fa-solid fa-pen" id="profileImageIcon"></i>
                                        <input type="file" id="oneSignalImage" name="one_signal_image"
                                               class="image-upload d-none" accept="image/*"/>
                                    </label>
                                </span>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="form-group col-md-6 mb-3">
                                        <label for="url" class="form-label mb-3">URL</label>
                                        <input type="text" class="form-control" name="url" id="url" value=""
                                               placeholder="Enter URL">
                                    </div>
                                </div>
                                <div class="d-flex mt-3">
                                    <button type="submit" class="btn btn-primary me-5">Send</button>
                                    <button type="button" class="btn btn-secondary">Cancel</button>
                                </div>
                            </form>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
@endsection
