@extends('layouts.app')
@section('title')
    Onesignal-Configuration
@endsection
@section('content')
    <div class="container-fluid">
        <div class="row">
            <div class="col-xl-12 col-lg-12">
                <div class="card">
                    <div class="card-body">
                        @include('flash::message')
                        @if ($errors->any())
                            <div class="alert alert-danger">{{ $errors->first() }}</div>
                        @endif
                        @include('flash::message')
                        <form method="post">
                            <div class="row">
                                <div class="form-group col-md-6 mb-3">
                                    <label for="app_id" class="mb-3">Onesignal App ID <span
                                                class="text-danger">*</span></label>
                                    <input type="text" class="form-control" name="app_id"
                                           value="{{ !empty($data['app_id']) ? $data['app_id'] : '' }}"
                                           placeholder="Onesignal App ID" required="">
                                </div>
                                <div class="form-group col-md-6 mb-3">
                                    <label for="rest_api_key" class="mb-3">Onesignal Rest Api <span
                                                class="text-danger">*</span></label>
                                    <input type="text" class="form-control" name="rest_api_key"
                                           value="{{ !empty($data['rest_api_key']) ? $data['rest_api_key'] : '' }}"
                                           placeholder="Onesignal Rest Api" required="">
                                </div>
                            </div>
                            <div class="d-flex mt-3">
                                <button type="submit" class="btn btn-primary me-5">Save</button>
                                <button type="button" class="btn btn-secondary">Cancel</button>
                            </div>
                        </form>
                    </div>
                </div>
            </div>
        </div>
    </div>
@endsection
