<div id="editFloatingButtonModal" class="modal fade" role="dialog" aria-hidden="true">
    <div class="modal-dialog">
        <!-- Modal content-->
        <div class="modal-content">
            <div class="modal-header">
                <h3 class="modal-title" id="exampleModalLabel">{{ __('Edit Floating Button') }}</h3>
                <button type="button" class="btn-close" data-bs-dismiss="modal"
                        aria-label="Close"></button>
            </div>
            {{ Form::open(['id'=>'editFloatingButtonForm','files' => 'true']) }}
            @method('put')
            <div class="modal-body">
                {{ Form::hidden('floating_button_id', null,['id' => 'floatingButtonId']) }}
                <div class="alert alert-danger d-none hide" id="editValidationErrorsBox"></div>
                <div class="row">
                    <div class="form-group col-md-12 mb-5">
                        {{ Form::label('title', __('Title').(':'), ['class' => 'form-label']) }}
                        <span class="required"></span>
                        {{ Form::text('title', null, ['id'=>'editButtonTitle','class' => 'form-control','required']) }}
                    </div>
                    <div class="form-group col-md-12 mb-5">
                        {{ Form::label('url', __('URL').(':'),['class' => 'form-label']) }}
                        {{ Form::text('url', null, ['id'=>'editButtonURL','class' => 'form-control','required']) }}
                    </div>
                    <div class="mb-5 form-group col-md-12" io-image-input="true">
                        <label for="editButtonInputImage" class="form-label">Image:</label>
                        <div class="d-block">
                            <div class="image-picker">
                                <div class="image previewImage" id="editButtonInputImage"
                                     style="background-image: url('{{asset('images/avatar.png') }}')"></div>
                                <span class="picker-edit rounded-circle text-gray-500 fs-small" title="edit">
                                    <label>
                                    <i class="fa-solid fa-pen" id="profileImageIcon"></i>
                                        <input type="file" id="appLogo" name="floating_button_image"
                                               class="image-upload d-none" accept="image/*"/>
                                    </label>
                                </span>
                            </div>
                        </div>
                    </div>
                    <div class="form-group">
                        {{ Form::label('status', __('Status').(':'),['class' => 'form-label']) }}
                        <div class="form-check form-switch">
                            <input class="form-check-input h-20px w-30px" type="checkbox"
                                   id="floatingButtonStatus" name="status">
                        </div>
                    </div>
                </div>
            </div>
            <div class="modal-footer pt-0">
                {{ Form::button(__('messages.common.save'), ['type' => 'submit','class' => 'btn btn-primary m-0','id' => 'EditFloatingSaveBtn','data-loading-text' => "<span class='spinner-border spinner-border-sm'></span> Processing..."]) }}
                <button type="button" class="btn btn-secondary"
                        data-bs-dismiss="modal">{{ __('messages.common.cancel') }}</button>
            </div>
            {{ Form::close() }}
        </div>
    </div>
</div>
