@extends('layouts.app')
@section('title')
    About-App-Configuration
@endsection
@section('content')
    <div class="container-fluid">
        <div class="d-flex flex-column">
            <div class="card">
                <div class="card-body">
                    @include('flash::message')
                    @if ($errors->any())
                        <div class="alert alert-danger">{{ $errors->first() }}</div>
                    @endif
                    @include('flash::message')
                    <div class="row">
                        <div class="col-xl-12 col-lg-12">
                            <div class="new-user-info">
                                <form method="post">
                                    @csrf
                                    <input type="hidden" name="type" value="about">
                                    <div class="row">
                                        <div class="form-group col-md-12 mb-3">
                                            <label class="mb-3">Is Show Social Option? </label>
                                            <div class="form-group">
                                                <div class="d-inline">
                                                    <input type="radio" id="isShowSocialYes" name="is_show_social"
                                                           value="1" {{ !empty($aboutAppConfigurationData) && $aboutAppConfigurationData['is_show_social'] == 1 ? 'checked' : '' }} class="form-check-input mx-1">
                                                    <label class="form-label" for="isShowSocialYes">
                                                        Yes </label>
                                                </div>
                                                <div class="d-inline">
                                                    <input type="radio" id="isShowSocialNo" name="is_show_social"
                                                           value="0" {{ !empty($aboutAppConfigurationData) && $aboutAppConfigurationData['is_show_social'] == 0 ? 'checked' : '' }} class="form-check-input mx-1">
                                                    <label class="form-label" for="isShowSocialNo"> No </label>
                                                </div>
                                            </div>
                                        </div>
                                        <div class="form-group col-md-6 mb-3">
                                            <label for="whatsAppNumber" class="form-label">Whatsapp Number</label>
                                            <input type="text" class="form-control" name="whats_app_number"
                                                   id="whatsAppNumber" value="{{ $aboutAppConfigurationData['whats_app_number'] }}"
                                                   placeholder="Enter Your whatsApp number">
                                        </div>
                                        <div class="form-group col-md-6 mb-3">
                                            <label for="instagramUrl" class="form-label">Instagram URL</label>
                                            <input type="url" class="form-control" name="instagram_url" id="instagramUrl"
                                                   value="{{ $aboutAppConfigurationData['instagram_url'] }}"
                                                   placeholder="Enter Your instagram URL">
                                        </div>
                                        <div class="form-group col-md-6 mb-3">
                                            <label for="twitterUrl" class="form-label">Twitter URL</label>
                                            <input type="url" class="form-control" name="twitter_url" id="twitterUrl"
                                                   value="{{ $aboutAppConfigurationData['twitter_url'] }}"
                                                   placeholder="Enter Your twitter URL">
                                        </div>
                                        <div class="form-group col-md-6 mb-3">
                                            <label for="facebookUrl" class="form-label">Facebook URL</label>
                                            <input type="url" class="form-control" name="facebook_url" id="facebookUrl"
                                                   value="{{ $aboutAppConfigurationData['facebook_url'] }}"
                                                   placeholder="Enter Your facebook URL">
                                        </div>
                                        <div class="form-group col-md-6 mb-3">
                                            <label for="callNumber" class="form-label">Phone Number</label>
                                            <input type="text" class="form-control" name="call_number" id="callNumber"
                                                   value="{{ $aboutAppConfigurationData['call_number'] }}" placeholder="Enter Your phone number">
                                        </div>
                                        <div class="form-group col-md-6 mb-3">
                                            <label for="snapchat" class="form-label">Snapchat</label>
                                            <input type="text" class="form-control" name="snapchat" id="snapchat"
                                                   value="{{ $aboutAppConfigurationData['snapchat'] }}" placeholder="Enter Your snapchat URL">
                                        </div>
                                        <div class="form-group col-md-6 mb-3">
                                            <label for="skype" class="form-label">Skype</label>
                                            <input type="url" class="form-control" name="skype" id="skype"
                                                   value="{{ $aboutAppConfigurationData['skype'] }}" placeholder="Enter Your skype URL">
                                        </div>
                                        <div class="form-group col-md-6 mb-3">
                                            <label for="messenger" class="form-label">Messenger</label>
                                            <input type="url" class="form-control" name="messenger" id="messenger"
                                                   value="{{ $aboutAppConfigurationData['messenger'] }}"
                                                   placeholder="Enter Your messenger URL">
                                        </div>
                                        <div class="form-group col-md-6 mb-3">
                                            <label for="youtube" class="form-label">Youtube</label>
                                            <input type="url" class="form-control" name="youtube" id="youtube"
                                                   value="{{ $aboutAppConfigurationData['youtube'] }}"
                                                   placeholder="Enter Your youtube URL">
                                        </div>
                                        <div class="form-group col-md-6 mb-3">
                                            <label for="copyright" class="form-label">Copy Right</label>
                                            <input type="text" class="form-control" name="copyright" id="copyright"
                                                   value="{{ $aboutAppConfigurationData['copyright'] }}"
                                                   placeholder="Enter Your Copy Right ">
                                        </div>
                                        <div class="form-group col-md-6 mb-3">
                                            <label for="description" class="form-label">Description</label>
                                            <textarea class="form-control" id="description" name="description"
                                                      placeholder="Enter Description" rows="3">{{ $aboutAppConfigurationData['description'] }}</textarea>
                                        </div>
                                    </div>
                                    <div class="d-flex mt-3">
                                        <button type="submit" class="btn btn-primary me-5">Save</button>
                                        <button type="button" class="btn btn-secondary">Cancel</button>
                                    </div>
                                </form>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
@endsection
