document.addEventListener('turbo:load', loadWalkThrough)

function loadWalkThrough () {

}

listenHiddenBsModal('#addWalkThroughModal', function (e) {
    $('#addWalkThroughForm')[0].reset()
    $('#walkThoughPreviewImage').
        css('background-image', 'url(' + defaultImage + ')')
    livewire.emit('refresh')
})

listenClick('#addWalkThroughModalBtn', function () {
    $('#addWalkThroughModal').modal('show').appendTo('body')
})

listenSubmit('#addWalkThroughForm', function (e) {
    e.preventDefault()
    $('#walkThrough').prop('disabled', true)
    $.ajax({
        url: route('walk-through.store'),
        type: 'POST',
        data: new FormData(this),
        processData: false,
        contentType: false,
        success: function (result) {
            if (result.success) {
                displaySuccessMessage(result.message)
                livewire.emit('refresh')
                $('#addWalkThroughModal').modal('hide')
                $('#walkThrough').prop('disabled', false)
            }
        },
        error: function (result) {
            displayErrorMessage(result.responseJSON.message)
            $('#walkThrough').prop('disabled', false)
        },
    })
})

listenClick('.walk-through-edit-btn', function (event) {
    let editWalkThroughId = $(event.currentTarget).data('id')
    renderData(editWalkThroughId)
})

function renderData (id) {
    $.ajax({
        url: route('walk-through.edit', id),
        type: 'GET',
        success: function (result) {
            let walkThrough = result.data
            $('#walkThroughId').val(result.data.id)
            $('#editWalkThroughTitle').val(result.data.title)
            $('#editWalkThroughSubtitle').val(result.data.subtitle)
            $('#editWalkThoughPreviewImage').
                css('background-image',
                    'url( "' + result.data.walk_through_image + '")')
            if (walkThrough.status == 1) {
                $('#walkThroughtStatus').prop('checked', true)
            } else {
                $('#walkThroughtStatus').prop('checked', false)
            }
            $('#editWalkThroughModal').modal('show')
        },
    })
}

listenSubmit('#editWalkThroughForm', function (event) {
    event.preventDefault()
    $('#productUpdateBtn').prop('disabled', true)
    let walkThroughId = $('#walkThroughId').val()
    $.ajax({
        url: route('walk-through.update', walkThroughId),
        type: 'POST',
        data: new FormData(this),
        contentType: false,
        processData: false,
        success: function (result) {
            if (result.success) {
                displaySuccessMessage(result.message)
                $('#editWalkThroughModal').modal('hide')
                Livewire.emit('refresh')
                $('#productUpdateBtn').prop('disabled', true)
            }
        },
        error: function (result) {
            displayErrorMessage(result.responseJSON.message)
            $('#productUpdateBtn').prop('disabled', false)
        },
    })
})

listenClick('.walk-through-status', function (event) {
    let walkThrough = $(event.currentTarget).data('id')
    $.ajax({
        type: 'PUT',
        url: route('walk.Through.status'),
        data: { id: walkThrough },
        success: function (result) {
            livewire.emit('refresh')
            displaySuccessMessage(result.message)
        },
    })
})

listenClick('.walk-through-delete-btn', function (event) {
    let recordId = $(event.currentTarget).data('id')
    deleteItem(route('walk-through.destroy', recordId), 'Walk Through')
})
