document.addEventListener('turbo:load', loadUserProfileData)

function loadUserProfileData() {
    listenSubmit('#changePasswordForm' ,function (e){
        e.preventDefault()
        $('#pages').prop('disabled', true);
        $.ajax({
            url: route('change-password'),
            type: 'POST',
            data: new FormData(this),
            processData: false,
            contentType: false,
            success: function (result) {
                if (result.success) {
                    displaySuccessMessage(result.message)
                    $('#addPagesModal').modal('hide');
                    Livewire.emit('refresh');
                    setTimeout($.proxy(function() {
                        Turbo.visit(window.location.href)
                    }, this), 3000);
                    $('#pages').prop('disabled', true);
                }
            },
            error: function (result) {
                displayErrorMessage(result.responseJSON.message)
                $('#walkThrough').prop('disabled', false);
            },
        })
    })
}

