document.addEventListener('turbo:load', loadSplashConfiguration)

function loadSplashConfiguration () {
    let splashFirstColor = $('#splashFirstColor').val()
    let splashSecondColor = $('#splashSecondColor').val()
    let splashTitleColor = $('#splashTitleColor').val()
    let back = $('#splashBackgroundPreviewImage').css('background-image')
    changeColor()
    textcolor()
    listenChange('#splashFirstColor', function () {
        splashFirstColor = $(this).val()
        changeColor()
    })
    listenChange('#splashSecondColor', function () {
        splashSecondColor = $(this).val()
        changeColor()
    })
    listenChange('#splashTitleColor', function () {
        splashTitleColor = $(this).val()
        textcolor()
    })

    function changeColor () {
        $('#selectedColor').
            css('background',
                'linear-gradient(to right bottom,' + splashFirstColor + ',' +
                splashSecondColor + ')')

    }

    function textcolor () {
        $('.splash-preview-title').css('color', splashTitleColor)
    }

    listenChange('#splashLogo', function () {
        document.getElementById('logoPreview').src = window.URL.createObjectURL(
            this.files[0])
    })

    $('#splashTitle').keyup(function () {
        let dInput = this.value
        $('.splash-preview-title').text(dInput)
    })

    listenChange('#splashBackground', function () {
        $('#selectedColor').
            css({
                'background-image': 'url(' + window.URL.createObjectURL(
                    this.files[0]) + ')',
            })
    })

    if (($('#enableSplashBackground').is(':checked'))) {
        $('#selectedColor').
            css({
                'background-image': back,
            })
    }

    listenChange('#enableSplashBackground', function () {
        if (($('#enableSplashBackground').is(':checked'))) {
            $('#selectedColor').
                css({
                    'background-image': back,
                })
        } else {
            $('#selectedColor').
                css('background',
                    'linear-gradient(to right bottom,' + splashFirstColor +
                    ',' +
                    splashSecondColor + ')')
        }
    })
}

listenChange('#enableSplashLogo', function () {
    $('.splash-logo').toggleClass('d-none')
    if ($('#enableSplashLogo').is(':checked')) {
        $('.splash-preview-img').removeClass('d-none')
    } else {
        $('.splash-preview-img').addClass('d-none')
    }
})
listenChange('#enableSplashTitle', function () {
    $('.splash_title').toggleClass('d-none')
    if ($('#enableSplashTitle').is(':checked')) {
        $('.splash-preview-title').removeClass('d-none')
    } else {
        $('.splash-preview-title').addClass('d-none')
    }

})
listenChange('#enableSplashBackground', function () {
    $('.splash_Background').toggleClass('d-none')
    
})
