document.addEventListener('turbo:load', loadRightheaderNavData)

function loadRightheaderNavData () {
    
}

listen('change', '.is-right-head-action-enable', function (event) {
    let rightHeaderId = $(event.currentTarget).attr('data-id')
    $.ajax({
        url: $('#rightHeaderNavigationUrl').val() + '/' + rightHeaderId +
            '/enable-disable',
        method: 'post',
        cache: false,
        success: function (result) {
            if (result.success) {
                displaySuccessMessage(result.message)
                window.livewire.emit('refresh')
            }
        },
    })
})

listen('change', '.right-header-change-status', function (event) {
    let rightHeaderId = $(event.currentTarget).attr('data-id')
    $.ajax({
        url: $('#rightHeaderNavigationUrl').val() + '/' + rightHeaderId +
            '/change-status',
        method: 'post',
        cache: false,
        success: function (result) {
            if (result.success) {
                displaySuccessMessage(result.message)
                window.livewire.emit('refresh')
            }
        },
    })
})

listenClick('.right-header-url-edit-btn', function (event) {
    if ($('.ajaxCallIsRunning').val()) {
        return
    }
    ajaxCallInProgress()
    let leftHeaderUrlId = $(event.currentTarget).attr('data-id')
    renderRightHeaderURL(leftHeaderUrlId)
})

function renderRightHeaderURL (id) {
    $.ajax({
        url: $('#rightHeaderNavigationUrl').val() + '/' + id + '/change-url',
        type: 'GET',
        success: function (result) {
            if (result.success) {
                let leftHeaderURL = result.data
                $('#addRightHeaderURLId').val(leftHeaderURL.id)
                $('#leftRightURL').val(leftHeaderURL.url)
                $('#updateRightHeaderURLModal').modal('show')
                ajaxCallCompleted()
            }
        },
        error: function (result) {
            manageAjaxErrors(result)
        },
    })
}

listenSubmit('#updateRightHeaderURLForm', function (event) {
    event.preventDefault()
    var loadingButton = jQuery(this).find('#updateRightHeaderURLBtn')
    loadingButton.button('loading')
    let id = $('#addRightHeaderURLId').val()

    $.ajax({
        url: $('#rightHeaderNavigationUrl').val() + '/' + id + '/' +
            'update-url',
        type: 'post',
        data: $(this).serialize(),
        success: function (result) {
            if (result.success) {
                window.livewire.emit('refresh')
                displaySuccessMessage(result.message)
                $('#updateRightHeaderURLModal').modal('hide')
                $(loadingButton).attr('disabled', false)
            }
        },
        error: function (result) {
            UnprocessableInputError(result)
        },
        complete: function () {
            loadingButton.button('reset')
        },
    })
})
