document.addEventListener('turbo:load', loadPages)

function loadPages () {

}

listenHiddenBsModal('#addPagesModal', function (e) {
    $('#addPagesForm')[0].reset()
    $('#pagesPreviewImage').
        css('background-image', 'url(' + defaultImage + ')')
    livewire.emit('refresh')
})

listenClick('#addPagesModalBtn', function () {
    $('#addPagesModal').modal('show').appendTo('body')
})

listenSubmit('#addPagesForm', function (e) {
    e.preventDefault()
    $('#pages').prop('disabled', true)
    $.ajax({
        url: route('pages.store'),
        type: 'POST',
        data: new FormData(this),
        processData: false,
        contentType: false,
        success: function (result) {
            if (result.success) {
                displaySuccessMessage(result.message)
                $('#addPagesModal').modal('hide')
                livewire.emit('refresh')
                $('#pages').prop('disabled', false)
            }
        },
        error: function (result) {
            displayErrorMessage(result.responseJSON.message)
            $('#pages').prop('disabled', false)
        },
    })
})

listenClick('.pages-edit-btn', function (event) {
    let editPagesId = $(event.currentTarget).data('id')
    renderData(editPagesId)
})

function renderData (id) {
    $.ajax({
        url: route('pages.edit', id),
        type: 'GET',
        success: function (result) {
            let pages = result.data
            $('#pagesId').val(result.data.id)
            $('#editPagesTitle').val(result.data.title)
            $('#editPagesURL').val(result.data.URL)
            $('#editPagesPreviewImage').
                css('background-image',
                    'url( "' + result.data.pages_image + '")')
            if (pages.status == 1) {
                $('#pagesStatus').prop('checked', true)
            } else {
                $('#pagesStatus').prop('checked', false)
            }
            $('#editPagesModal').modal('show')
        },
    })
}

listenSubmit('#editPagesForm', function (event) {
    event.preventDefault()
    $('#editPages').prop('disabled', true)
    let pagesId = $('#pagesId').val()
    $.ajax({
        url: route('pages.update', pagesId),
        type: 'POST',
        data: new FormData(this),
        contentType: false,
        processData: false,
        success: function (result) {
            if (result.success) {
                displaySuccessMessage(result.message)
                $('#editPagesModal').modal('hide')
                Livewire.emit('refresh')
                $('#editPages').prop('disabled', true)
            }
        },
        error: function (result) {
            displayErrorMessage(result.responseJSON.message)
            $('#editPages').prop('disabled', false)
        },
    })
})

listenClick('.pages-status', function (event) {
    let pages = $(event.currentTarget).data('id')
    $.ajax({
        type: 'PUT',
        url: route('pages.status'),
        data: { id: pages },
        success: function (result) {
            livewire.emit('refresh')
            displaySuccessMessage(result.message)
        },
    })
})

listenClick('.pages-delete-btn', function (event) {
    let recordId = $(event.currentTarget).data('id')
    deleteItem(route('pages.destroy', recordId), 'pages')
})
