document.addEventListener('turbo:load', loadFloatingCreateEdit)

function loadFloatingCreateEdit () {

}

listenHiddenBsModal('#addFloatingButtonModal', function (e) {
    $('#addFloatingButtonForm')[0].reset()
    $('#buttonInputImage').
        css('background-image', 'url(' + defaultImage + ')')
})

listenSubmit('#addFloatingButtonForm', function (event) {
    event.preventDefault()
    $('#FloatingSaveBtn').prop('disabled', true)
    $.ajax({
        url: route('floating-button.store'),
        type: 'POST',
        data: new FormData(this),
        processData: false,
        contentType: false,
        success: function (result) {
            if (result.success) {
                displaySuccessMessage(result.message)
                $('#addFloatingButtonModal').modal('hide')
                Livewire.emit('refresh')
                Turbo.visit(window.location.href)
                $('#FloatingSaveBtn').prop('disabled', true)
            }
        },
        error: function (result) {
            displayErrorMessage(result.responseJSON.message)
            $('#FloatingSaveBtn').prop('disabled', false)
        },
    })
})

listenClick('.edit-floating-btn', function (event) {
    let editButtonId = $(event.currentTarget).data('id')
    renderData(editButtonId)
})

function renderData (editButtonId) {
    $.ajax({
        url: route('floating-button.edit', editButtonId),
        type: 'GET',
        success: function (result) {
            let floatingButton = result.data
            $('#floatingButtonId').val(result.data.id)
            $('#editButtonTitle').val(result.data.title)
            $('#editButtonURL').val(result.data.url)
            $('#editButtonInputImage').
                css('background-image',
                    'url( "' + result.data.floating_button_image + '")')
            if (floatingButton.status == 1) {
                $('#floatingButtonStatus').prop('checked', true)
            } else {
                $('#floatingButtonStatus').prop('checked', false)
            }
            $('#editFloatingButtonModal').modal('show')
        },
    })
}

listenSubmit('#editFloatingButtonForm', function (event) {
    event.preventDefault()
    $('#EditFloatingSaveBtn').prop('disabled', true)
    let buttonId = $('#floatingButtonId').val()
    $.ajax({
        url: route('floating-button.update', buttonId),
        type: 'POST',
        data: new FormData(this),
        contentType: false,
        processData: false,
        success: function (result) {
            if (result.success) {
                displaySuccessMessage(result.message)
                $('#editFloatingButtonModal').modal('hide')
                Livewire.emit('refresh')
                $('#EditFloatingSaveBtn').prop('disabled', true)
            }
        },
        error: function (result) {
            displayErrorMessage(result.responseJSON.message)
            $('#EditFloatingSaveBtn').prop('disabled', false)
        },
    })
})

listenClick('.floating-button-status', function (event) {
    let floatingButtonId = $(event.currentTarget).data('id')
    $.ajax({
        type: 'PUT',
        url: route('floating.button.status'),
        data: { id: floatingButtonId },
        success: function (result) {
            livewire.emit('refresh')
            displaySuccessMessage(result.message)
        },
    })
})

listenClick('.delete-floating-btn', function (event) {
    let recordId = $(event.currentTarget).data('id')
    deleteItem(route('floating-button.destroy', recordId), 'Floating Button')
})
