document.addEventListener('turbo:load', loadBottomNavCreateEdit)

function loadBottomNavCreateEdit () {
   

// listenHiddenBsModal('#addBottomNavigationModal', function () {
//     $('#addBottomNavigationBtn').attr('disabled', false);
//     resetModalForm('#addBottomNavigationForm', '#bottomNavigationValidationErrorsBox');
// });
// listenHiddenBsModal('#bloodBanksEditModal', function () {
//     $('#bloodBanksEditBtnSave').attr('disabled', false);
//     resetModalForm('#bloodBanksEditForm', '#bloodBanksEditValidationErrorsBox');
// });
}

listenSubmit('#addBottomNavigationForm', function (event) {
    event.preventDefault()
    var loadingButton = jQuery(this).find('#addBottomNavigationBtn')
    loadingButton.button('loading')
    $(loadingButton).attr('disabled', true)

    $.ajax({
        url: $('#bottomNavigationCreateUrl').val(),
        type: 'POST',
        data: new FormData(this),
        processData: false,
        contentType: false,
        success: function (result) {
            if (result.success) {
                window.livewire.emit('refresh')
                displaySuccessMessage(result.message)
                $('#addBottomNavigationModal').modal('hide')
                $(loadingButton).attr('disabled', false)
                Turbo.visit(window.location.href);
            }
        },
        error: function (result) {
            printErrorMessage('#bottomNavigationValidationErrorsBox',
                result)
            $(loadingButton).attr('disabled', false)
        },
        complete: function () {
            loadingButton.button('reset')
        },
    })
})

listenClick('.bottom-navigation-edit-btn', function (event) {
    if ($('.ajaxCallIsRunning').val()) {
        return
    }
    ajaxCallInProgress()
    let bottomNavigationId = $(event.currentTarget).attr('data-id')
    renderBottomNavigation(bottomNavigationId)
})

function renderBottomNavigation (id) {
    $.ajax({
        url: $('#bottomNavigationUrl').val() + '/' + id + '/edit',
        type: 'GET',
        success: function (result) {
            if (result.success) {
                let bottomNavi = result.data
                $('#bottomNavigationId').val(bottomNavi.id)
                $('#menuEditTitle').val(bottomNavi.title)
                $('#menuEditURL').val(bottomNavi.url)
                $('#editBottomImagePreview').
                    css('background-image',
                        'url("' + result.data.bottom_image + '")')
                if (bottomNavi.status == 1) {
                    $('#menuEditStatus').prop('checked', true)
                } else {
                    $('#menuEditStatus').prop('checked', false)
                }
                $('#editBottomNavigationModal').modal('show')
                ajaxCallCompleted()
            }
        },
        error: function (result) {
            manageAjaxErrors(result)
        },
    })
}

listenSubmit('#editBottomNavigationForm', function (event) {
    event.preventDefault()
    var loadingButton = jQuery(this).find('#btnBottomNavigationEditSave')
    loadingButton.button('loading')
    let id = $('#bottomNavigationId').val()
    $.ajax({
        url: $('#bottomNavigationUrl').val() + '/' + id,
        type: 'post',
        data: new FormData(this),
        processData: false,
        contentType: false,
        success: function (result) {
            if (result.success) {
                window.livewire.emit('refresh')
                displaySuccessMessage(result.message)
                $('#editBottomNavigationModal').modal('hide')
                Turbo.visit(window.location.href)
                $(loadingButton).attr('disabled', false)
            }
        },
        error: function (result) {
            UnprocessableInputError(result)
        },
        complete: function () {
            loadingButton.button('reset')
        },
    })
})

listenClick('.bottom-nav-status', function (event) {
    let bottomNavId = $(event.currentTarget).data('id')
    $.ajax({
        type: 'PUT',
        url: route('bottom.nav.status'),
        data: { id: bottomNavId },
        success: function (result) {
            livewire.emit('refresh')
            displaySuccessMessage(result.message)
        },
    })
})

listenClick('.bottom-navigation-delete-btn', function (event) {
    let navigationId = $(event.currentTarget).attr('data-id')
    deleteItem($('#bottomNavigationUrl').val() + '/' + navigationId, '',
        'Bottom Navigation')
})
