<?php

namespace Database\Seeders;

use App\Models\AppConfiguration;
use App\Models\SplashConfiguration;
use Illuminate\Database\Seeder;

class SplashConfigurationTableSeeder extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        $appLogoUrl = ('/images/avatar.png');

        $splashData = [
            'first_color'              => '#4581e8',
            'second_color'             => '#4581e8',
            'splash_logo'              => $appLogoUrl,
            'enable_splash_logo'       => 0,
            'enable_splash_title'      => 0,
            'splash_title'             => 'web app',
            'splash_title_color'       => '#ffffff',
            'enable_splash_background' => 0,
            'splash_background'        => $appLogoUrl,
        ];
        foreach ($splashData as $key => $value) {
            $splashDataExist = SplashConfiguration::where('key', $key)->exists();
            if (!$splashDataExist) {
                SplashConfiguration::create(['key' => $key, 'value' => $value]);
            }
        }
    }
}
