<?php

namespace Database\Seeders;

use App\Models\RightHeaderNavigation;
use Illuminate\Database\Seeder;

class RightHeaderNavigationTableSeeder extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        $rightHeaderData = [
            'Back Button 1',
            'Back Button 2',
            'Home',
            'Profile',
            'Close',
            'Search',
            'Add',
        ];
        foreach ($rightHeaderData as $title) {
            $rightHeaderDataExist = RightHeaderNavigation::where('title', $title)->exists();
            if (!$rightHeaderDataExist) {
                $rightHeader = RightHeaderNavigation::create([
                    'title'  => 'Back Button 1',
                    'url'    => '',
                    'active' => 0,
                    'status' => 0,
                ]);
                $rightHeader->addMediaFromUrl(asset('images/left_header/ic_back1.png'))->toMediaCollection(RightHeaderNavigation::IMAGE,
                    config('app.media_disc'));

                $rightHeader1 = RightHeaderNavigation::create([
                    'title'  => 'Back Button 2',
                    'url'    => '',
                    'active' => 0,
                    'status' => 1,
                ]);
                $rightHeader1->addMediaFromUrl(asset('images/left_header/ic_back2.png'))->toMediaCollection(RightHeaderNavigation::IMAGE,
                    config('app.media_disc'));

                $rightHeader2 = RightHeaderNavigation::create([
                    'title'  => 'Home',
                    'url'    => '',
                    'active' => 0,
                    'status' => 1,
                ]);
                $rightHeader2->addMediaFromUrl(asset('images/left_header/ic_home.png'))->toMediaCollection(RightHeaderNavigation::IMAGE,
                    config('app.media_disc'));


                $rightHeader3 = RightHeaderNavigation::create([
                    'title'  => 'Profile',
                    'url'    => 'https://www.google.com/',
                    'active' => 0,
                    'status' => 0,
                ]);
                $rightHeader3->addMediaFromUrl(asset('images/left_header/ic_profile.png'))->toMediaCollection(RightHeaderNavigation::IMAGE,
                    config('app.media_disc'));

                $rightHeader4 = RightHeaderNavigation::create([
                    'title'  => 'Close',
                    'url'    => '',
                    'active' => 0,
                    'status' => 0,
                ]);
                $rightHeader4->addMediaFromUrl(asset('images/left_header/ic_close.png'))->toMediaCollection(RightHeaderNavigation::IMAGE,
                    config('app.media_disc'));


                $rightHeader5 = RightHeaderNavigation::create([
                    'title'  => 'Search',
                    'url'    => 'https://www.google.com/',
                    'active' => 0,
                    'status' => 0,
                ]);
                $rightHeader5->addMediaFromUrl(asset('images/left_header/ic_search.png'))->toMediaCollection(RightHeaderNavigation::IMAGE,
                    config('app.media_disc'));

                $rightHeader6 = RightHeaderNavigation::create([
                    'title'  => 'Add',
                    'url'    => 'https://www.google.com/',
                    'active' => 0,
                    'status' => 0,
                ]);
                $rightHeader6->addMediaFromUrl(asset('images/left_header/ic_add.png'))->toMediaCollection(RightHeaderNavigation::IMAGE,
                    config('app.media_disc'));
            }
        }
    }
}
