<?php

namespace Database\Seeders;

use App\Models\ProgressBar;
use Illuminate\Database\Seeder;

class ProgressBarTableSeeder extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        $progressBarData = [
            'progress_bar_required' => '1',
            'loader_style'          => 'FadingFour',
        ];
        foreach ($progressBarData as $key => $value) {
            $progressBarDataExist = ProgressBar::where('key', $key)->exists();
            if (!$progressBarDataExist) {
                ProgressBar::create(['key' => $key, 'value' => $value]);
            }
        }
    }
}
