<?php

namespace Database\Seeders;

use App\Models\LeftHeaderNavigation;
use Illuminate\Database\Seeder;

class LeftHeaderNavigationTableSeeder extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        $leftHeaderData = [
            'Back Button 1',
            'Back Button 2',
            'Home',
            'Profile',
            'Close',
            'Search',
            'Add',
        ];
        foreach ($leftHeaderData as $title) {
            $leftHeaderDataExist = LeftHeaderNavigation::where('title', $title)->exists();
            if (!$leftHeaderDataExist) {
                $leftHeader = LeftHeaderNavigation::create([
                    'title'  => 'Back Button 1',
                    'url'    => '',
                    'active' => 0,
                    'status' => 0,
                ]);
                $leftHeader->addMediaFromUrl(asset('images/left_header/ic_back1.png'))->toMediaCollection(LeftHeaderNavigation::IMAGE,
                    config('app.media_disc'));

                $leftHeader1 = LeftHeaderNavigation::create([
                    'title'  => 'Back Button 2',
                    'url'    => '',
                    'active' => 0,
                    'status' => 1,
                ]);
                $leftHeader1->addMediaFromUrl(asset('images/left_header/ic_back2.png'))->toMediaCollection(LeftHeaderNavigation::IMAGE,
                    config('app.media_disc'));

                $leftHeader2 = LeftHeaderNavigation::create([
                    'title'  => 'Home',
                    'url'    => '',
                    'active' => 0,
                    'status' => 1,
                ]);
                $leftHeader2->addMediaFromUrl(asset('images/left_header/ic_home.png'))->toMediaCollection(LeftHeaderNavigation::IMAGE,
                    config('app.media_disc'));


                $leftHeader3 = LeftHeaderNavigation::create([
                    'title'  => 'Profile',
                    'url'    => 'https://www.google.com/',
                    'active' => 0,
                    'status' => 0,
                ]);
                $leftHeader3->addMediaFromUrl(asset('images/left_header/ic_profile.png'))->toMediaCollection(LeftHeaderNavigation::IMAGE,
                    config('app.media_disc'));

                $leftHeader4 = LeftHeaderNavigation::create([
                    'title'  => 'Close',
                    'url'    => '',
                    'active' => 0,
                    'status' => 0,
                ]);
                $leftHeader4->addMediaFromUrl(asset('images/left_header/ic_close.png'))->toMediaCollection(LeftHeaderNavigation::IMAGE,
                    config('app.media_disc'));


                $leftHeader5 = LeftHeaderNavigation::create([
                    'title'  => 'Search',
                    'url'    => 'https://www.google.com/',
                    'active' => 0,
                    'status' => 0,
                ]);
                $leftHeader5->addMediaFromUrl(asset('images/left_header/ic_search.png'))->toMediaCollection(LeftHeaderNavigation::IMAGE,
                    config('app.media_disc'));

                $leftHeader6 = LeftHeaderNavigation::create([
                    'title'  => 'Add',
                    'url'    => 'https://www.google.com/',
                    'active' => 0,
                    'status' => 0,
                ]);
                $leftHeader6->addMediaFromUrl(asset('images/left_header/ic_add.png'))->toMediaCollection(LeftHeaderNavigation::IMAGE,
                    config('app.media_disc'));
            }
        }
    }
}
