<?php

namespace Database\Seeders;

use App\Models\AdsConfiguration;
use Illuminate\Database\Seeder;

class CreateAdsConfigurationSeeder extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        $adsConfiguration = [
            'ads_type'              => 1,
            'admob_banner_id'       => 'ca-app-pub-3940256099942544/6300978111',
            'admob_intential_id'    => 'ca-app-pub-3940256099942544/1033173712',
            'admob_banner_idios'    => 'ca-app-pub-3940256099942544/6385469711',
            'admob_intential_idios' => 'ca-app-pub-3940256099942544/1056248712',
        ];
        foreach ($adsConfiguration as $key => $value) {
            $adsConfigurationDataExist = AdsConfiguration::where('key', $key)->exists();
            if (!$adsConfigurationDataExist) {
                AdsConfiguration::create(['key' => $key, 'value' => $value]);
//                AdsConfiguration::create([
//                    'key'   => 'facebook_banner_id',
//                    'value' => 'IMG_16_9_APP_INSTALL#288204860002404_346910524131837',
//                ]);
//                AdsConfiguration::create([
//                    'key'   => 'facebook_intential_id',
//                    'value' => 'IMG_16_9_APP_INSTALL#288204860002404_346910814131808',
//                ]);
//                AdsConfiguration::create([
//                    'key'   => 'facebook_banner_idios',
//                    'value' => 'IMG_16_9_APP_INSTALL#288204789452404_346910524131837',
//                ]);
//                AdsConfiguration::create([
//                    'key'   => 'facebook_intential_idios',
//                    'value' => 'IMG_16_9_APP_INSTALL#288951478452404_346910814131808',
//                ]);
            }
        }
    }
}

