<?php

namespace Database\Seeders;

use App\Models\AboutAppConfiguration;
use App\Models\AppConfiguration;
use Illuminate\Database\Seeder;

class AppConfigurationTableSeeder extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        $appLogoUrl = ('/images/avatar.png');

        $appConfiguration = [
            'app_name'                        => 'Infy Web App',
            'base_url'                        => 'http://infywebapp.com/',
            'app_language'                    => 'en',
            'navigation_style'                => 2,
            'header_style'                    => 1,
            'bottom_navigation'               => 1,
            'tab_style'                       => 1,
            'disable_header'                  => 1,
            'disable_footer'                  => 1,
            'javascript_enable'               => 1,
            'required_flash_screen'           => 1,
            'is_support_zoom_functionality'   => 0,
            'required_walkthrough'            => 1,
            'is_support_webrtc_functionality' => 0,
            'is_enable_pull_to_refresh'       => 1,
            'walkthrough_style'               => 3,
            'clear_cookies'                   => 0,
            'required_exit_popup_screen'      => 1,
            'required_floating_action_button' => 1,
            'floating_button_style'           => 1,
            'app_logo'                        => $appLogoUrl,
            'floating_buttton_logo'           => $appLogoUrl,
            'theme_style'                     => '#195CDD',
            'gradient_enable'                 => 0,
        ];

        foreach ($appConfiguration as $key => $value) {
            $appConfigurationDataExist = AppConfiguration::where('key', $key)->exists();
            if (!$appConfigurationDataExist) {
                AppConfiguration::create(['key' => $key, 'value' => $value]);
            }
        }
    }
}
