<?php

namespace Database\Seeders;

use App\Models\AboutAppConfiguration;
use Illuminate\Database\Seeder;

class AboutAppConfigurationSeeder extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        $aboutAppConfiguration = [
            'whats_app_number' => '+91123456789',
            'instagram_url'    => 'https://www.instagram.com/',
            'twitter_url'      => 'https://twitter.com/login',
            'facebook_url'     => 'https://www.facebook.com/',
            'call_number'      => '9876543210',
            'snapchat'         => 'https://snapchat.com/login',
            'skype'            => 'https://www.skype.com/en/',
            'messenger'        => 'https://www.messenger.com/',
            'youtube'          => 'https://www.youtube.com/',
            'is_show_social'    => '1',
            'copyright'        => 'Copyright 2021 Meetmighty',
            'description'      => 'Convert Your Website To An App.',
        ];
        foreach ($aboutAppConfiguration as $key => $value) {
            $aboutAppDataExist = AboutAppConfiguration::where('key', $key)->exists();
            if (!$aboutAppDataExist) {
                AboutAppConfiguration::create(['key' => $key, 'value' => $value]);
            }
        }
    }
}
