<?php

namespace App\Repositories;


use App\Models\Product;

use App\Models\ShareContent;
use App\Models\WalkThrough;

use Illuminate\Support\Facades\DB;


/**
 * Class AppConfigurationRepository
 */
class ShareContentRepository extends BaseRepository
{
    public $fieldSearchable = [
        'key',
    ];

    /**
     * @inheritDoc
     */
    public function getFieldsSearchable()
    {
        return $this->fieldSearchable;
    }

    /**
     * @inheritDoc
     */
    public function model()
    {
        return ShareContent::class;
    }

    public function store($input)
    {
        try {
            DB::beginTransaction();

            foreach ($input as $key => $value) {
                $contentData = ShareContent::updateOrCreate(['key' => $key], ['value' => $value]);
            }
            DB::commit();

            return $contentData;
        } catch (Exception $e) {
            DB::rollBack();

            throw new UnprocessableEntityHttpException($e->getMessage());
        }
    }
}
