<?php

namespace App\Repositories;

use App\Models\ProgressBar;
use Illuminate\Support\Arr;
use Spatie\MediaLibrary\MediaCollections\Exceptions\FileDoesNotExist;
use Spatie\MediaLibrary\MediaCollections\Exceptions\FileIsTooBig;

/**
 * Class ProgressBarRepository
 */
class ProgressBarRepository extends BaseRepository
{
    public $fieldSearchable = [
        'key',
    ];

    /**
     * @inheritDoc
     */
    public function getFieldsSearchable()
    {
        return $this->fieldSearchable;
    }

    /**
     * @inheritDoc
     */
    public function model()
    {
        return ProgressBar::class;
    }

    /**
     * @param  array  $input
     * @param  int  $userId
     *
     * @return void
     * @throws FileIsTooBig
     *
     * @throws FileDoesNotExist
     */
    public function update($input,$userId)
    {
        $inputArr = Arr::except($input, ['_token']);

        foreach ($inputArr as $key => $value) {

            /** @var ProgressBar $progressBar */
            $progressBar = ProgressBar::where('key', $key)->first();
          
            if (! $progressBar) {
                continue;
            }

            $progressBar->update(['value' => $value]);
        }
    }
}
