<?php

namespace App\Models;

use App\Models\Contracts\JsonResourceful;
use Barryvdh\LaravelIdeHelper\Eloquent;
use Illuminate\Database\Eloquent\Builder;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Support\Carbon;

/**
 * App\Models\UserAgent
 *
 * @property int $id
 * @property string $title
 * @property string|null $for_android
 * @property string|null $for_iOS
 * @property Carbon|null $created_at
 * @property Carbon|null $updated_at
 * @method static Builder|UserAgent newModelQuery()
 * @method static Builder|UserAgent newQuery()
 * @method static Builder|UserAgent query()
 * @method static Builder|UserAgent whereCreatedAt($value)
 * @method static Builder|UserAgent whereForAndroid($value)
 * @method static Builder|UserAgent whereForIOS($value)
 * @method static Builder|UserAgent whereId($value)
 * @method static Builder|UserAgent whereTitle($value)
 * @method static Builder|UserAgent whereUpdatedAt($value)
 * @mixin Eloquent
 */
class UserAgent extends Model implements JsonResourceful
{
    use HasFactory;
    
    protected $table = 'user_agent';
    
    protected $fillable = [
        'title',
        'for_android',
        'for_iOS',
    ];

    public function prepareAttributes(): array
    {
        return [
            'id'        => $this->id,
            'title'     => $this->title,
            'for_android'  => $this->for_android,
            'for_ios'    => $this->for_iOS,
        ];
    }
}
