<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class ThemeStyle extends Model
{
    use HasFactory;
    
    protected $table = 'theme_styles';
    
    protected $fillable = [
        'key',
        'value',
    ];
    
    const DEFAULT = "#195CDD";
    const THEME_1 = "#880e4f";
    const THEME_2 = "#e667b1";
    const THEME_3 = "#4a148c";
    const THEME_4 = "#b71c1c";
    const THEME_5 = "#1a237e";
    const THEME_6 = "#0d47a1";
    const THEME_7 = "#01579b";
    const THEME_8 = "#094c4f";
    const THEME_9 = "#bfc726";
    const THEME_10 = "#1b5e20";
    const THEME_11 = "#ba8d06";
    const THEME_12 = "#6835f2";
    const THEME_13 = "#212121";
    const THEME_14 = "#263238";
    const THEME_15 = "#dd2c00";
    const THEME_16 = "#1b5ddb";

    const THEME = [
        self::DEFAULT => "Default",
        self::THEME_1 => "Theme 1",
        self::THEME_2 => "Theme 2",
        self::THEME_3 => "Theme 3",
        self::THEME_4 => "Theme 4",
        self::THEME_5 => "Theme 5",
        self::THEME_6 => "Theme 6",
        self::THEME_7 => "Theme 7",
        self::THEME_8 => "Theme 8",
        self::THEME_9 => "Theme 9",
        self::THEME_10 => "Theme 10",
        self::THEME_11 => "Theme 11",
        self::THEME_12 => "Theme 12",
        self::THEME_13 => "Theme 13",
        self::THEME_14 => "Theme 14",
        self::THEME_15 => "Theme 15",
        self::THEME_16 => "Theme 16",
    ];
}
