<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Spatie\MediaLibrary\HasMedia;
use Spatie\MediaLibrary\InteractsWithMedia;
use Spatie\MediaLibrary\MediaCollections\Models\Media;
use function Symfony\Component\Translation\t;

/**
 * App\Models\SplashConfiguration
 *
 * @property int $id
 * @property string $key
 * @property string $value
 * @property \Illuminate\Support\Carbon|null $created_at
 * @property \Illuminate\Support\Carbon|null $updated_at
 * @property-read string $app_logo
 * @property-read string $splash_background
 * @property-read \Spatie\MediaLibrary\MediaCollections\Models\Collections\MediaCollection|Media[] $media
 * @property-read int|null $media_count
 * @method static \Illuminate\Database\Eloquent\Builder|SplashConfiguration newModelQuery()
 * @method static \Illuminate\Database\Eloquent\Builder|SplashConfiguration newQuery()
 * @method static \Illuminate\Database\Eloquent\Builder|SplashConfiguration query()
 * @method static \Illuminate\Database\Eloquent\Builder|SplashConfiguration whereCreatedAt($value)
 * @method static \Illuminate\Database\Eloquent\Builder|SplashConfiguration whereId($value)
 * @method static \Illuminate\Database\Eloquent\Builder|SplashConfiguration whereKey($value)
 * @method static \Illuminate\Database\Eloquent\Builder|SplashConfiguration whereUpdatedAt($value)
 * @method static \Illuminate\Database\Eloquent\Builder|SplashConfiguration whereValue($value)
 * @mixin \Eloquent
 */
class SplashConfiguration extends Model implements HasMedia
{
    use HasFactory, InteractsWithMedia;

    protected $table = 'splash_configuration';
    const SPLASH_LOGO = 'splash_logo';
    const SPLASH_BACKGROUND = 'splash_background';
    
    protected $fillable = [
        'key',
        'value',
    ];
//const enable and disable

    const ACTIVE = 1;
    const INACTIVE = 0;

    const STATUS = [
        self::ACTIVE    => true,
        self::INACTIVE  => false,
    ];
    public function getAppLogoAttribute(): string
    {
        /** @var Media $media */
        $media = $this->getMedia(self::SPLASH_LOGO)->first();
        if (!empty($media)) {
            return $media->getFullUrl();
        }
        return asset('images/avatar.png');
    }

    public function getSplashBackgroundAttribute(): string
    {
        /** @var Media $media */
        $media = $this->getMedia(self::SPLASH_BACKGROUND)->first();
        if (!empty($media)) {
            return $media->getFullUrl();
        }

        return asset('images/avatar.png');
    }

}
