<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Spatie\MediaLibrary\HasMedia;
use Spatie\MediaLibrary\InteractsWithMedia;
use Spatie\MediaLibrary\MediaCollections\Models\Media;

class FloatingButton extends Model implements HasMedia
{
    use HasFactory ,InteractsWithMedia;
    
    const FLOATING_BUTTON_IMAGE = 'floating_button_image';

    const ACTIVE = 1;
    const INACTIVE = 0;
    
    const STATUS = [
        self::ACTIVE    => 'Active',
        self::INACTIVE  => 'Inactive',
    ];
    /**
     * @var mixed
     */
    public static $rules = [
        'title'                 => 'required',
        'url'                   => 'required',
        'floating_button_image' => 'required',
    ];
    
    protected $table = 'floating_buttons';

    protected  $appends = ['floating_button_image'];
    protected $fillable = [
        'title',
        'url',
        'status',
    ];

    public function getFloatingButtonImageAttribute(): string
    {
        /** @var Media $media */
        $media = $this->getMedia(self::FLOATING_BUTTON_IMAGE)->first();
        if (!empty($media)) {
            return $media->getFullUrl();
        }
        return asset('images/avatar.png');
    }
}
