<?php

namespace App\Models;

use App\Models\Contracts\JsonResourceful;
use Barryvdh\LaravelIdeHelper\Eloquent;
use Illuminate\Database\Eloquent\Builder;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Support\Carbon;
use Spatie\MediaLibrary\HasMedia;
use Spatie\MediaLibrary\InteractsWithMedia;
use Spatie\MediaLibrary\MediaCollections\Models\Collections\MediaCollection;
use Spatie\MediaLibrary\MediaCollections\Models\Media;


/**
 * App\Models\AppConfiguration
 *
 * @property int $id
 * @property string $key
 * @property string $value
 * @property Carbon|null $created_at
 * @property Carbon|null $updated_at
 * @property-read string $app_logo
 * @property-read string $floating_button
 * @property-read MediaCollection|Media[] $media
 * @property-read int|null $media_count
 * @method static Builder|AppConfiguration newModelQuery()
 * @method static Builder|AppConfiguration newQuery()
 * @method static Builder|AppConfiguration query()
 * @method static Builder|AppConfiguration whereCreatedAt($value)
 * @method static Builder|AppConfiguration whereId($value)
 * @method static Builder|AppConfiguration whereKey($value)
 * @method static Builder|AppConfiguration whereUpdatedAt($value)
 * @method static Builder|AppConfiguration whereValue($value)
 * @mixin Eloquent
 */
class AppConfiguration extends Model implements HasMedia, JsonResourceful
{
    use HasFactory, InteractsWithMedia;

    protected $with = ['media'];

    protected $fillable = [
        'key',
        'value',
    ];

    const APPLOGO = 'app_logo';
    const FLOATINGBUTTON = 'floating_button';

    protected $appends = ['app_logo','floating_button'];

    const LANGUAGES = [
        'en' => 'English',
        'es' => 'Spanish',
        'fr' => 'French',
        'de' => 'German',
        'ru' => 'Russian',
        'pt' => 'Portuguese',
        'ar' => 'Arabic',
        'zh' => 'Chinese',
        'tr' => 'Turkish',
        'it' => 'Italian',
    ];

    const SIDE_DRAWER = 1;
    const BOTTOM_NAVIGATION = 2;
    const FULL_SCREEN = 3;
    const TABS = 4;
    const SIDE_DRAWER_AND_BOTTON_NAVIGATION = 5;
    
    const NAVIGATION_STYLE = [
        self::SIDE_DRAWER => 'Side Drawer',
        self::BOTTOM_NAVIGATION => 'Bottom Navigation',
        self::FULL_SCREEN => 'Full Screen',
        self::TABS => 'Tabs',
        self::SIDE_DRAWER_AND_BOTTON_NAVIGATION => 'Side Drawer & Bottom Navigation',
    ];
 const TRUE = 1;
 const FALSE = 0;
  const STATUS = [
      self::TRUE => true,
      self::FALSE => false,
  ];

    const LEFT = 1;
    const CENTER = 2;
    const EMPTY_HEADER = 3;

    const HEADER_STYLE = [
        self::LEFT => 'Left',
        self::CENTER => 'Center',
        self::EMPTY_HEADER => 'Empty Header',
     
    ];

    public static $rules = [
        'app_name'              => 'required',
        'base_url'              => 'required',
        'app_language'          => 'required',
        'app_logo'              => 'nullable|mimes:jpeg,png,jpg|max:2000',
        'floating_buttton_logo' => 'nullable|mimes:jpeg,png,jpg|max:2000',
    ];

    public function getAppLogoAttribute(): string
    {
        /** @var Media $media */
        $media = $this->getMedia(self::APPLOGO)->first();
        if (! empty($media)) {
            return $media->getFullUrl();
        }
      
        return asset('images/avatar.png');
    }

    public function getFloatingButtonAttribute(): string
    {
        /** @var Media $media */
        $media = $this->getMedia(self::FLOATINGBUTTON)->first();
        if (! empty($media)) {
            return $media->getFullUrl();
        }

        return asset('images/avatar.png');
    }
    
    public function prepareAttributes(): array
    {
        return [
            $this->key => $this->value,
        ];
    }
}
