<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class AdsConfiguration extends Model
{
    use HasFactory;

    protected $table = 'ads_configurations';

    protected $fillable = [
        'key',
        'value',
    ];

    const NONE = 1;
    const ADMOB = 2;
    const FACEBOOK = 3;

    const  TYPE = [
        self::NONE     => 'None',
        self::ADMOB    => 'AdMob',
        self::FACEBOOK => 'Facebook',
    ];


}
