<?php

namespace App\Jobs;

use App\Models\OneSignalConfiguration;
use Illuminate\Bus\Queueable;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Foundation\Bus\Dispatchable;
use Illuminate\Queue\InteractsWithQueue;
use Illuminate\Queue\SerializesModels;
use OneSignal;

class SendOneSignalPushJob implements ShouldQueue
{
    use Dispatchable, InteractsWithQueue, Queueable, SerializesModels;

    private $url;
    private $heading;
    private $message;
    private $image;


    /**
     * @param $url
     * @param $heading
     * @param $message
     * @param $image
     */
    public function __construct($url, $heading, $message, $image)
    {
        $this->url = $url;
        $this->heading = $heading;
        $this->message = $message;
        $this->image = $image;
    }

    /**
     * Execute the job.
     *
     * @return void
     */
    public function handle()
    {
        $this->sendOneSignalPush($this->url, $this->message, $this->heading, $this->image);
    }

    /**
     * @param string $url
     * @param string $message
     * @param string $headings
     * @param string $image
     *
     * @return void|bool
     */
    public function sendOneSignalPush($url, $message, $headings, $image)
    {
        $parameters = [
            'headings'          => [
                'en' => $headings,
            ],
            'contents'          => [
                'en' => $message,
            ],
            'included_segments' => ["Subscribed Users"],
            'chrome_web_icon'    => $image,
//            'url'               => $url,
//            'web_url' => $url,
            'app_url' => $url,
//            'chrome_web_image'  => $image,
        ];
        
        $oneSignalAppID = OneSignalConfiguration::where('key', 'app_id')->first()->value;
        $oneSignalAPIKey = OneSignalConfiguration::where('key', 'rest_api_key')->first()->value;
        
        \Config::set('onesignal.app_id', $oneSignalAppID);
        \Config::set('onesignal.rest_api_key', $oneSignalAPIKey);
        
        $result = OneSignal::sendNotificationCustom($parameters);

        return true;
    }
}
