<?php

namespace App\Http\Resources;

use App\Models\Contracts\JsonResourceful;
use Barryvdh\LaravelIdeHelper\Eloquent;
use Illuminate\Http\Resources\Json\JsonResource;

abstract class BaseJsonResource extends JsonResource
{
    private static $usedWithCollection;

    /** @var Eloquent|JsonResourceful */
    public $resource;

    public static function usingWithCollection()
    {
        
        self::$usedWithCollection = true;
    }

    public static function notUsingWithCollection()
    {
        static::$usedWithCollection = null;
    }

    public function toArray($request)
    {
        return $this->resource->prepareAttributes();
    }
}
