<?php

namespace App\Http\Livewire;

use Rappasoft\LaravelLivewireTables\Views\Column;
use App\Models\UserAgent;

class UserAgentTable extends LivewireTableComponent
{
    protected $model = UserAgent::class;
    public $showButtonOnHeader = true;
    public $buttonComponent = 'user_agent.add-button';
    protected $listeners = ['refresh' => '$refresh', 'resetPage'];

    public function configure(): void
    {
        $this->setPrimaryKey('id');
        $this->setTdAttributes(function (Column $column, $row, $columnIndex, $rowIndex) {
            if ($columnIndex == '1') {
                return [
                    'class' => 'text-center',
                    'width' => '10%',
                ];
            }

            return [];
        });
    }

    public function columns(): array
    {
        return [
           
            Column::make("Title", "title")
                ->view('user_agent.columns.title')
                ->sortable(),
            Column::make("action", "id")
                ->view('user_agent.columns.action')
                ->sortable(),
          
        ];
    }
}
