<?php

namespace App\Http\Livewire;

use Rappasoft\LaravelLivewireTables\DataTableComponent;
use Rappasoft\LaravelLivewireTables\Views\Column;
use App\Models\Pages;

class PagesTable extends LivewireTableComponent
{
    protected $model = Pages::class;
    public $showButtonOnHeader = true;
    public $buttonComponent = 'pages.add-button';
    protected $listeners = ['refresh' => '$refresh', 'resetPage'];

    public function configure(): void
    {
        $this->setPrimaryKey('id');
    }

    public function columns(): array
    {
        return [
            Column::make("Image", "id")
                ->view('pages.columns.image'),
                
            Column::make("Title", "title")
                ->searchable()
                ->view('pages.columns.title')
                ->sortable(),
            Column::make("URL", "URL")
                ->searchable()
                ->view('pages.columns.url')
                ->sortable(),
            Column::make("Status", "status")
                ->view('pages.columns.status')
                ->sortable(),
            Column::make("Action", "created_at")
                ->view('pages.columns.action')
                ->sortable(),
           
        ];
    }
}
