<?php

namespace App\Http\Livewire;

use Rappasoft\LaravelLivewireTables\Views\Column;
use App\Models\BottomNavigationStyle;

class BottomNavigationStyleTable extends LivewireTableComponent
{
    protected $model = BottomNavigationStyle::class;
    
    public $showButtonOnHeader = true;
    public $buttonComponent = 'bottom_navigation_style.add-button';
    protected $listeners = ['refresh' => '$refresh', 'resetPage'];

    public function resetPage($pageName = 'page')
    {
        $rowsPropertyData = $this->getRows()->toArray();
        $prevPageNum = $rowsPropertyData['current_page'] - 1;
        $prevPageNum = $prevPageNum > 0 ? $prevPageNum : 1;
        $pageNum = count($rowsPropertyData['data']) > 0 ? $rowsPropertyData['current_page'] : $prevPageNum;

        $this->setPage($pageNum, $pageName);
    }

    public function configure(): void
    {
        $this->setPrimaryKey('id')
            ->setDefaultSort('bottom_navigation_styles.created_at', 'desc')
            ->setQueryStringStatus(false);
    }

    public function columns(): array
    {
        return [
            Column::make("Title", "title")
                ->view('bottom_navigation_style.columns.title')
                ->sortable(),
            Column::make("URL", "url")
                ->view('bottom_navigation_style.columns.url')
                ->sortable(),
            Column::make("Image", "title")
                ->view('bottom_navigation_style.columns.navigation_image')
                ->sortable(),
            Column::make(__('STATUS'), "status")
                ->view('bottom_navigation_style.columns.status'),
            Column::make(__('ACTION'), "id")
                ->view('bottom_navigation_style.action-button'),
        ];
    }
}
