<?php

namespace App\Http\Controllers;

use App\DataTables\UserDataTable;
use App\Http\Requests\ChangePasswordRequest;
use App\Http\Requests\UpdateUserProfileRequest;
use App\Repositories\UserRepository;
use Illuminate\Contracts\Foundation\Application;
use Illuminate\Contracts\View\Factory;
use Illuminate\Contracts\View\View;
use Illuminate\Http\Request;
use Illuminate\Http\JsonResponse;
use Illuminate\Support\Facades\Auth;
use Laracasts\Flash\Flash;
use Yajra\DataTables\Facades\DataTables;


class UserController extends AppBaseController
{
    /**
     * @var UserRepository
     */
    private $userRepository;

    /**
     * @param UserRepository $userRepository
     */
    public function __construct(UserRepository $userRepository)
    {
        $this->userRepository = $userRepository;
    }
    
    /**
     *
     * @return Application|Factory|View
     */
    public function index()
    {
        return view('users.index');
    }

    /**
     * @param Request $request
     * @throws \Exception
     *
     * @return Application|Factory|View
     */
    public function dataTableIndex(Request $request)
    {
        if ($request->ajax()) {
            return Datatables::of((new UserDataTable())->get())->make(true);
        }

        return view('users.data-table-index');
    }

    public function horizontalTable(){
         return view('horizontal-users.index');
    }


    public function changePassword(Request $request)
    {
        $input = $request->all();

        try {
            $user = $this->userRepository->changePassword($input);

            return $this->sendResponse($user, 'Password Update successfully.');

        } catch (Exception $e) {
            return $this->sendError($e->getMessage(), 422);
        }
    }

    /**
     * @return Application|Factory|View
     */
    public function editProfile()
    {
        $user = Auth::user();

        return view('user_profile.index', compact('user'));
    }

    /**
     * @param UpdateUserProfileRequest $request
     *
     * @return Application
     */
    public function updateProfile(UpdateUserProfileRequest $request)
    {
        $this->userRepository->updateProfile($request->all());
        Flash::success(__('User Profile updated successfully.'));

        return redirect(route('profile.setting'));
    }
}
