<?php

namespace App\Http\Controllers;

use App\Http\Requests\CreateUserAgentRequest;
use App\Models\UserAgent;
use App\Repositories\UserAgentRepository;
use Illuminate\Http\Request;
use Laracasts\Flash\Flash;

class UserAgentController extends AppBaseController
{


    /**
     * @var UserAgentRepository
     */
    private $UserAgentRepository;

    /**
     * @param UserAgentRepository $UserAgentRepository
     */
    public function __construct(UserAgentRepository $UserAgentRepository)
    {
        $this->UserAgentRepository = $UserAgentRepository;
    }

    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        return view('user_agent.index');
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        return view('user_agent.create');
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param \Illuminate\Http\Request $request
     * @return \Illuminate\Http\Response
     */
    public function store(CreateUserAgentRequest $request)
    {
        $id = 1;
        $userAgent = $this->UserAgentRepository->store($request->all(), $id);

        Flash::success('User Agent create successfully');

        return redirect(route('useragent.index'));
//        return $this->sendResponse($userAgent, 'Walk Through create successfully.');
    }

    /**
     * Display the specified resource.
     *
     * @param int $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param int $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        $agent = UserAgent::whereId($id)->first();

        return view('user_agent.edit', compact('agent'));

    }

    /**
     * Update the specified resource in storage.
     *
     * @param \Illuminate\Http\Request $request
     * @param int $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        $input = $request->all();

        $service = $this->UserAgentRepository->update($input, $id);

        Flash::success('User Agent update successfully');

        return redirect(route('useragent.index'));
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param int $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        //
    }
}
