<?php

namespace App\Http\Controllers;

use App\Models\AppConfiguration;
use App\Models\ThemeStyle;
use App\Repositories\ThemeStyleRepository;
use Illuminate\Http\Request;
use Laracasts\Flash\Flash;

class ThemeStyleController extends Controller
{

    public function __construct(ThemeStyleRepository $themeStyleRepo)
    {
        $this->themeStyleRepo = $themeStyleRepo;
    }


    public function index()
    {
        $themeStyleData = AppConfiguration::pluck('value', 'key')->toArray();
      
        return view('theme_style.index', compact('themeStyleData'));
    }

    /**
     * @param Request $request
     *
     *
     * @return \Illuminate\Http\RedirectResponse
     */
    public function store(Request $request)
    {
        $input = $request->all();
        $themeColor = AppConfiguration::where('key', 'theme_style')->first();
        
        if (!empty($themeColor)) {
            $themeColor->update(['value' => $input['themeStyle']]);
        } else {
            AppConfiguration::create([
                'key'   => 'theme_style',
                'value' => $input['themeStyle'],
            ]);
        }

        $gradientIs = AppConfiguration::where('key', 'gradient_enable')->first();

        if (!empty($gradientIs)) {
            $gradientIs->update(['value' => $input['gradient_enable']]);
        } else {
            AppConfiguration::create([
                'key'   => 'gradient_enable',
                'value' => $input['gradient_enable'],
            ]);
        }
        
        Flash::success('Theme Style updated successfully.');
        
        return redirect()->back();
    }
}
