<?php

namespace App\Http\Controllers;

use App\Models\SplashConfiguration;
use App\Repositories\AppConfigurationRepository;
use App\Repositories\SplashConfigurationRepository;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Redirect;
use Laracasts\Flash\Flash;

class SplashConfigurationController extends Controller
{

    /**
     * @var SplashConfigurationRepository
     */
    private $splashConfigurationRepo;

    /**
     * @param SplashConfigurationRepository $appConfigRepository
     */
    public function __construct(SplashConfigurationRepository $splashConfigurationRepo)
    {
        $this->splashConfigurationRepo = $splashConfigurationRepo;
    }
    
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
         $splashConfiguration = SplashConfiguration::pluck('value', 'key')->toArray();
        return view('splash_configuration.index',compact('splashConfiguration'));
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        //
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        $id = 1;
        $this->splashConfigurationRepo->update($request->all(),$id);

        Flash::success( 'Splash Configuration Store Successfully');

        return Redirect::back();
    }
    
    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        //
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        //
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        //
    }
}
