<?php

namespace App\Http\Controllers;

use App\Models\LeftHeaderNavigation;
use App\Models\RightHeaderNavigation;
use Illuminate\Contracts\Foundation\Application;
use Illuminate\Contracts\View\Factory;
use Illuminate\Contracts\View\View;
use Illuminate\Http\JsonResponse;
use Illuminate\Http\Request;

class RightHeaderNavigationController extends AppBaseController
{
    /**
     * @return Application|Factory|View
     */
    public function index()
    {
        return view('right_header_navigation.index');
    }

    /**
     * @param  int  $id
     *
     * @return JsonResponse
     */
    public function enableDisable($id)
    {
        $leftHeader = RightHeaderNavigation::findOrFail($id);
        $active = $leftHeader->active == 0 ? 1 : 0;
        $leftHeader->update(['active' => $active]);

        return $this->sendSuccess( __('Status changed successfully'));
    }

    /**
     * @param  int  $id
     *
     * @return JsonResponse
     */
    public function changeStatus($id)
    {
        $leftHeader = RightHeaderNavigation::findOrFail($id);
        $active = $leftHeader->status == 0 ? 1 : 0;
        $leftHeader->update(['status' => $active]);

        return $this->sendSuccess( __('Status changed successfully'));
    }

    /**
     * @param  RightHeaderNavigation $rightHeaderNavigation
     *
     * @return JsonResponse
     */
    public function changeUrledit(RightHeaderNavigation $rightHeaderNavigation)
    {
        return $this->sendResponse($rightHeaderNavigation, __('Right Header URL retrieved '));
    }

    public function updateUrl(Request $request, RightHeaderNavigation $rightHeaderNavigation)
    {
        $url = $request->url ?? '';

        $rightHeaderNavigation->update(['url' => $url]);

        return $this->sendSuccess( __('URL updated successfully'));
    }
}
