<?php

namespace App\Http\Controllers;

use App\Http\Requests\CreatePagesRequest;
use App\Http\Requests\UpdatePagesRequest;
use App\Models\Pages;
use App\Repositories\PagesRepository;
use Illuminate\Http\Request;
use Illuminate\Http\JsonResponse;

class PagesController extends AppBaseController
{

    /**
     * @var PagesRepository
     */
    private $PagesRepository;

    /**
     * @param PagesRepository $PagesRepository
     */
    public function __construct(PagesRepository $PagesRepository)
    {
        $this->PagesRepository = $PagesRepository;
    }
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        return view('pages.index');
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        //
    }


    /**
     * @param CreatePagesRequest $request
     *
     *
     * @return JsonResponse
     */
    public function store(CreatePagesRequest $request)
    {
        $pages = $this->PagesRepository->store($request->all());

        return $this->sendResponse($pages, 'Pages create successfully.');
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        $pages = Pages::whereId($id)->first();

        return $this->sendResponse($pages, 'Pages successfully retrieved.');
    }


    /**
     * @param UpdatePagesRequest $request
     * @param $id
     *
     *
     * @return JsonResponse
     */
    public function update(UpdatePagesRequest $request, $id)
    {
        $input = $request->all();

        $pages = $this->PagesRepository->update($input, $id);

        return $this->sendResponse($pages, 'Pages Update successfully.');
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        $Walk = Pages::whereId($id)->first();
//        $Walk->clearMediaCollection(Pages::PAGES_IMAGE);
        $Walk->delete();

        return $this->sendSuccess('pages deleted successfully.');
    
    }

    /**
     * @param Request $request
     *
     *
     * @return JsonResponse
     */
    public function changePagesStatus(Request $request)
    {
        $pages = Pages::findOrFail($request->id);
        $pages->update(['status' => !$pages->status]);

        return $this->sendResponse($pages, 'Pages Status Update Successfully');
    }


}
