<?php

namespace App\Http\Controllers;

use App\Models\LeftHeaderNavigation;
use App\Repositories\BottomNavigationRepository;
use Illuminate\Contracts\Foundation\Application;
use Illuminate\Contracts\View\Factory;
use Illuminate\Contracts\View\View;
use Illuminate\Http\JsonResponse;
use Illuminate\Http\Request;

class LeftHeaderNavigationController extends AppBaseController
{
    /**
     * @return Application|Factory|View
     */
    public function index()
    {
        return view('left_header_navigation.index');
    }

    /**
     * @param  int  $id
     *
     * @return JsonResponse
     */
    public function enableDisable($id)
    {
        $leftHeader = LeftHeaderNavigation::findOrFail($id);
        $active = $leftHeader->active == 0 ? 1 : 0;
        $leftHeader->update(['active' => $active]);

        return $this->sendSuccess( __('Status changed successfully'));
    }

    /**
     * @param  int  $id
     *
     * @return JsonResponse
     */
    public function changeStatus($id)
    {
        $leftHeader = LeftHeaderNavigation::findOrFail($id);
        $active = $leftHeader->status == 0 ? 1 : 0;
        $leftHeader->update(['status' => $active]);

        return $this->sendSuccess( __('Status changed successfully'));
    }

    /**
     * @param  LeftHeaderNavigation $leftHeaderNavigation
     *
     * @return JsonResponse
     */
    public function changeUrledit(LeftHeaderNavigation $leftHeaderNavigation)
    {
        return $this->sendResponse($leftHeaderNavigation, __('Left Header URL retrieved '));
    }

    /**
     * @param Request $request
     * @param LeftHeaderNavigation $leftHeaderNavigation
     *
     *
     * @return JsonResponse
     */
    public function updateUrl(Request $request, LeftHeaderNavigation $leftHeaderNavigation)
    {
        $url = $request->url ?? '';
        
        $leftHeaderNavigation->update(['url' => $url]);
        
        return $this->sendSuccess( __('URL updated successfully'));
    }
}
