<?php

namespace App\Http\Controllers;

use App\Models\LeftHeaderNavigation;
use App\Models\ProgressBar;
use App\Models\RightHeaderNavigation;
use App\Models\ThemeStyle;
use Illuminate\Contracts\Foundation\Application;
use Illuminate\Contracts\View\Factory;
use Illuminate\Contracts\View\View;
use Illuminate\Http\Request;

class DashboardController extends Controller
{
    /**
     *
     *
     * @return Application|Factory|View
     */
    public function index()
    {
        $data['progressStyle'] = ProgressBar::all()->count();
        $data['themeStyle']  = count(ThemeStyle::THEME) - 1 ;
        $data['leftHeaderIcon'] = LeftHeaderNavigation::all()->count();
        $data['rightHeaderIcon'] = RightHeaderNavigation::all()->count();
        
        return view('dashboard.dashboard', compact('data'));
    }
}
