<?php

namespace App\Http\Controllers\Api;

use App\Http\Controllers\AppBaseController;
use App\Models\SplashConfiguration;
use function GuzzleHttp\Promise\all;

class SplashConfigurationController extends AppBaseController
{
    public function index(){

        $splashConfiguration = SplashConfiguration::pluck('value', 'key')->toArray();
        $splashConfiguration['enable_splash_logo'] = SplashConfiguration::STATUS[$splashConfiguration['enable_splash_logo']];
        $splashConfiguration['enable_splash_title'] = SplashConfiguration::STATUS[$splashConfiguration['enable_splash_title']];
        $splashConfiguration['enable_splash_background'] = SplashConfiguration::STATUS[$splashConfiguration['enable_splash_background']];
        $splashConfiguration['splash_logo'] = asset($splashConfiguration['splash_logo']);
        $splashConfiguration['splash_background'] = asset($splashConfiguration['splash_background']);
        


        return $this->sendResponse($splashConfiguration, 'Splash Configuration fetch successfully');
    }
}
