<?php

namespace App\Http\Controllers\Api;

use App\Http\Controllers\AppBaseController;
use App\Http\Controllers\Controller;
use App\Models\AppConfiguration;
use App\Models\ExitPopupConfiguration;
use Illuminate\Http\Request;

class ExitPopupConfigurationController extends AppBaseController
{
    public function index()
    {
        $exitPopupData = ExitPopupConfiguration::pluck('value', 'key')->toArray();
        $exitPopupData['enable_Image'] = AppConfiguration::STATUS[$exitPopupData['enable_Image']];
        $exitPopupData['Image'] = asset($exitPopupData['Image']);
        return $this->sendResponse($exitPopupData, 'Exit Popup fetch successfully');
    }
}
