<?php

namespace App\Http\Controllers\Api;

use App\Http\Controllers\AppBaseController;
use App\Models\AppConfiguration;

class AppConfigurationsController extends AppBaseController
{
    public function index()
    {
        $data = AppConfiguration::all()->pluck('value', 'key');
        $data['navigation_style'] = AppConfiguration::NAVIGATION_STYLE[$data['navigation_style']];
        $data['header_style'] = AppConfiguration::HEADER_STYLE[$data['header_style']];
        $data['disable_header'] = AppConfiguration::STATUS[$data['disable_header']];
        $data['disable_footer'] = AppConfiguration::STATUS[$data['disable_footer']];
        $data['javascript_enable'] = AppConfiguration::STATUS[$data['javascript_enable']];
        $data['required_flash_screen'] = AppConfiguration::STATUS[$data['required_flash_screen']];
        $data['is_support_zoom_functionality'] = AppConfiguration::STATUS[$data['is_support_zoom_functionality']];
        $data['required_walkthrough'] = AppConfiguration::STATUS[$data['required_walkthrough']];
        $data['is_support_webrtc_functionality'] = AppConfiguration::STATUS[$data['is_support_webrtc_functionality']];
        $data['is_enable_pull_to_refresh'] = AppConfiguration::STATUS[$data['is_enable_pull_to_refresh']];
        $data['clear_cookies'] = AppConfiguration::STATUS[$data['clear_cookies']];
        $data['required_exit_popup_screen'] = AppConfiguration::STATUS[$data['required_exit_popup_screen']];
        $data['app_logo'] = asset($data['app_logo']);
       
        return $this->sendResponse($data, 'App Configuration fetch successfully');
    }
}
