<?php

namespace App\Http\Controllers;

use App\Models\AdsConfiguration;
use App\Repositories\AdsConfigurationRepository;
use Illuminate\Contracts\Foundation\Application;
use Illuminate\Contracts\View\Factory;
use Illuminate\Contracts\View\View;
use Illuminate\Http\RedirectResponse;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Redirect;
use Laracasts\Flash\Flash;

class AdsConfigurationController extends Controller
{

    /**
     * @param AdsConfigurationRepository $adsConfigurationRepo
     */
    public function __construct(AdsConfigurationRepository $adsConfigurationRepo)
    {
        $this->adsConfigurationRepo = $adsConfigurationRepo;
    }

    /**
     *
     *
     * @return Application|Factory|View
     */
    public function index()
    {
        $data = AdsConfiguration::pluck('value', 'key')->toArray();

        return view('ads_configurations.index', compact('data'));
    }

    /**
     * @param Request $request
     *
     *
     * @return RedirectResponse
     */
    public function update(Request $request)
    {
        $id = 1;
        $this->adsConfigurationRepo->update($request->all(), $id);

        Flash::success('Ads Configuration Updated Successfully');
        return Redirect::back();
    }
}
