@extends('layouts.main')

@section('title')
    Home
@endsection
@section('content')
    <section class="section">

        <div class="row">
            <div class="col-md-6">
                <div class="row">
                    <div class="col-md-6">
                        <a href="{{ url('customer') }}">

                            <div class="das-card">
                                <div class="des_icon bg1">

                                    <svg xmlns="http://www.w3.org/2000/svg" width="40" height="40"
                                        viewBox="0 0 256 256">
                                        <g id="total_user" transform="translate(12073 2992)">
                                            <rect id="Rectangle_1001" data-name="Rectangle 1001" width="128"
                                                height="128" transform="translate(-12073 -2992)" fill="none" />
                                            <g id="Group_8893" data-name="Group 8893"
                                                transform="translate(-12057.645 -2992)">
                                                <path id="Path_11570" data-name="Path 11570"
                                                    d="M111.11,0c8.408,1.568,16.2,4.625,22.6,10.4,14.447,13.022,20.087,29.213,14.713,47.989-5.228,18.268-17.984,29.186-36.863,32.23-25.206,4.064-49.133-14.78-51.5-40.254A46.482,46.482,0,0,1,98.18.314,6.735,6.735,0,0,0,99.118,0Z"
                                                    transform="translate(-22.4)" fill="#fff" />
                                                <path id="Path_11571" data-name="Path 11571"
                                                    d="M61.241,284.286q-28.855,0-57.709,0C.108,284.283.1,284.273.1,280.85c0-16.322-.245-32.648.05-48.964.608-33.671,16.317-58.2,45.686-74.277,3.643-1.994,6.694-2.252,10.774-.18,18.047,9.167,36.22,8.579,54.082-.833a5.779,5.779,0,0,1,5.788-.229q34.506,16.226,45.753,52.609c.747,2.414.228,3.391-2.2,4.368-23.63,9.491-37.1,26.7-39.337,52.336a47.234,47.234,0,0,0,1.075,14.356c.934,4.246.92,4.25-3.314,4.25H61.241"
                                                    transform="translate(0 -58.261)" fill="#fff" />
                                                <path id="Path_11572" data-name="Path 11572"
                                                    d="M261.022,264.812a45.14,45.14,0,1,0,45,45.158,44.949,44.949,0,0,0-45-45.158m25.84,36.816q-15.949,15.977-31.9,31.966c-1.283,1.3-2.1,1.07-3.254-.106q-8.317-8.448-16.759-16.765c-1.183-1.158-1.164-1.9.025-3.01,2.484-2.334,4.906-4.737,7.228-7.234,1.177-1.264,1.953-1.076,3.01.075,1.577,1.708,3.267,3.323,4.931,4.95,3.68,3.617,2.81,3.655,6.4.088,6.609-6.571,13.217-13.136,19.744-19.782,1.327-1.345,2.178-1.59,3.555-.056,2.222,2.472,4.681,4.731,7.022,7.1.394.4.726.876,1.145,1.389-.413.507-.738.989-1.139,1.389"
                                                    transform="translate(-80.729 -99.091)" fill="#fff" />
                                            </g>
                                        </g>
                                    </svg>
                                </div>
                                <div class="des_info">
                                    <div class="title-text">
                                        {{ __('Total Customers') }}
                                    </div>
                                    <div class="data text1">
                                        {{ $list['total_customer'] ? $list['total_customer'] : 0 }}
                                    </div>
                                </div>

                            </div>
                        </a>
                    </div>

                    <div class="col-md-6">
                        <a href="{{ url('property') }}">

                            <div class="das-card">
                                <div class="des_icon bg2">
                                    {{-- <img src="{{ url('assets/images/logo/favicon.png') }}" alt=""> --}}
                                    <svg xmlns="http://www.w3.org/2000/svg" width="40" height="40"
                                        viewBox="0 0 256 256">
                                        <g id="all_properties" transform="translate(11774 2992)">
                                            <rect id="Rectangle_1002" data-name="Rectangle 1002" width="128"
                                                height="128" transform="translate(-11774 -2992)" fill="none" />
                                            <g id="Group_8895" data-name="Group 8895"
                                                transform="translate(-11774 -2965.761)">
                                                <path id="Path_11573" data-name="Path 11573"
                                                    d="M0,81.672c1.424-4.246,4.381-7.063,8.129-9.4q55.955-34.839,111.832-69.8C125.206-.8,130.47-.834,135.715,2.442q56.434,35.251,112.85,70.53c6.774,4.24,9.1,10.915,6.226,17.258a13.128,13.128,0,0,1-18.932,5.906c-11.23-6.839-22.343-13.871-33.5-20.835q-36.322-22.677-72.616-45.4a3.1,3.1,0,0,0-3.823.04C91.357,51.584,56.665,73.024,22.248,94.9,13.215,100.637,3.28,97.9,0,88.165Z"
                                                    fill="#fff" />
                                                <path id="Path_11574" data-name="Path 11574"
                                                    d="M158.67,243.594H86.025c-.915,0-1.832.018-2.746-.013C73.265,243.236,68.221,238.021,68.22,228c0-25.214.072-50.428-.051-75.641-.032-6.73,2.572-11.487,8.321-15.042q37.153-22.969,74.125-46.229c5.423-3.393,10.732-3.448,16.164-.05q37.243,23.3,74.542,46.5c5.51,3.413,7.989,8.053,7.967,14.466-.085,25.3-.032,50.594-.036,75.891,0,10.365-5.188,15.619-15.69,15.679-13.23.075-26.462.02-39.693.02h-35.2m33.986-44.943h.022c0-2.325.069-4.653-.015-6.975-.164-4.559-3.155-7.646-7.717-7.779-4.48-.13-8.971-.138-13.451,0a7.623,7.623,0,0,0-7.653,7.855q-.122,6.725,0,13.452a7.5,7.5,0,0,0,7.481,7.742c4.645.164,9.3.15,13.948.007a7.5,7.5,0,0,0,7.359-7.334c.114-2.319.021-4.648.021-6.973m-67.859-.522c0,2.408-.075,4.819.016,7.223a7.562,7.562,0,0,0,7.6,7.621q6.722.169,13.451,0a7.607,7.607,0,0,0,7.757-7.748c.1-4.482.088-8.969,0-13.451a7.625,7.625,0,0,0-7.641-7.87c-4.479-.144-8.97-.135-13.451-.006-4.581.131-7.566,3.2-7.731,7.756-.078,2.156-.013,4.317-.007,6.476m14.361-51.8v-.009c-2.413,0-4.83-.1-7.237.022a7.017,7.017,0,0,0-7.064,6.967q-.219,7.356,0,14.723a6.981,6.981,0,0,0,7,7.033c4.9.151,9.818.142,14.723,0a7.224,7.224,0,0,0,7-6.851c.162-4.987.164-9.986,0-14.972a7.121,7.121,0,0,0-6.93-6.889c-2.489-.131-4.99-.025-7.486-.025m24.688,14.334h-.014c0,2.329-.064,4.66.014,6.987a7.4,7.4,0,0,0,7.232,7.43q7.231.194,14.471-.008a7.015,7.015,0,0,0,7.06-6.98q.226-7.354,0-14.719a6.965,6.965,0,0,0-7.009-7.014q-7.354-.221-14.72,0a7.176,7.176,0,0,0-7.018,7.068c-.112,2.407-.021,4.824-.021,7.236"
                                                    transform="translate(-30.876 -40.09)" fill="#fff" />
                                            </g>
                                        </g>
                                    </svg>
                                </div>
                                <div class="des_info">
                                    <div class="title-text">
                                        {{ __('Total Properties') }}
                                    </div>
                                    <div class="data text2">
                                        {{ $list['total_properties'] ? $list['total_properties'] : 0 }}
                                    </div>
                                </div>

                            </div>
                        </a>

                    </div>

                    <div class="col-md-6">
                        <a href="{{ url('property') . '?type=0' }}">
                            <div class="das-card">
                                <div class="des_icon bg3">
                                    <svg xmlns="http://www.w3.org/2000/svg" width="40" height="40"
                                        viewBox="0 0 256 256">
                                        <g id="sale_home" transform="translate(11029 2992)">
                                            <rect id="Rectangle_1004" data-name="Rectangle 1004" width="128"
                                                height="128" transform="translate(-11029 -2992)" fill="none" />
                                            <path id="Path_11580" data-name="Path 11580"
                                                d="M145.667,71.675c-2.66-3.68-6.373-5.047-10.833-5.047q-60.72.05-121.427-.027C6.887,66.589,2.347,69.055,0,75.222v70.86c2.347,6.167,6.907,8.64,13.407,8.627q60.34-.12,120.68-.04c.833,0,1.667.02,2.493-.04,6.3-.42,11.06-5.187,11.073-11.313.04-21.78.007-43.56.02-65.333a10.456,10.456,0,0,0-2.007-6.307M34.2,127.909c-1.653.093-3.327.013-4.987.013v-.02c-1.833,0-3.673.113-5.493-.027-2.367-.187-3.68-1.6-3.6-3.633.093-2.3,1.633-3.26,3.613-3.36,3.24-.16,6.493-.047,9.733-.087,2.5-.033,4.053-1.22,3.98-3.14-.087-2.22-1.54-3.2-3.593-3.407-1.073-.107-2.16-.087-3.24-.107-6.127-.087-10.333-3.94-10.507-9.627-.193-6.307,3.693-10.747,9.933-11.1,3.407-.193,6.827-.107,10.24-.02,2.567.06,4.033,1.407,4.073,3.46.04,2.153-1.48,3.54-4.187,3.613-3.16.08-6.327-.007-9.487.047-2.38.04-3.753,1.347-3.727,3.407.027,2.04,1.42,3.287,3.807,3.373,1,.033,2,0,3,.013,6.04.087,10.5,4.26,10.62,9.933.12,5.967-4.033,10.347-10.18,10.667m36.933-.373a3.2,3.2,0,0,1-3.647-.827,5.079,5.079,0,0,1-.827-1.227c-.807-1.393-.54-3.727-2.353-4.14a26.146,26.146,0,0,0-8.68-.087c-1.287.147-1.42,1.493-1.793,2.48-1.347,3.54-2.767,4.64-5,3.827-2.367-.867-2.807-2.753-1.487-6.353,2.94-8.02,5.893-16.047,8.787-24.087.693-1.92,1.58-3.633,3.873-3.607,2.18.027,2.993,1.713,3.653,3.533,2.98,8.273,6.02,16.527,9.033,24.793.28.773.487,1.573.653,2.093a3.531,3.531,0,0,1-2.213,3.6m23.893.393q-7.37.05-14.74,0c-3.62-.033-4.76-1.193-4.78-4.813-.033-4.153-.007-8.313-.007-12.467,0-4.327-.027-8.647.013-12.973.027-2.6,1.3-4.147,3.287-4.2,2.047-.053,3.507,1.633,3.527,4.293.047,6.733.087,13.467-.02,20.2-.033,2.153.633,2.98,2.853,2.873,3.24-.153,6.493-.06,9.747-.027,3.08.027,4.833,1.307,4.873,3.493.047,2.207-1.727,3.6-4.753,3.62m14.893-24.213c.04,1.707-.4,3.64,2.433,3.567,3.66-.1,7.327-.047,10.987-.007,2.713.027,4.007,1.14,4.027,3.34s-1.273,3.38-3.953,3.42c-3.58.053-7.167.153-10.733-.02-2.84-.14-2.787,1.547-2.78,3.52,0,1.893,0,3.453,2.687,3.313,3.407-.187,6.827-.08,10.233-.027,2.953.04,4.52,1.293,4.54,3.507s-1.54,3.56-4.453,3.593q-7.62.08-15.233,0c-3.287-.033-4.527-1.3-4.553-4.54-.033-4.32-.007-8.64-.007-12.953,0-4.24-.033-8.473.013-12.713.027-2.96,1.273-4.28,4.247-4.327q7.86-.11,15.727,0c2.74.027,4.26,1.38,4.267,3.527s-1.507,3.493-4.24,3.553c-3.58.073-7.167.133-10.733-.007-2.613-.107-2.513,1.52-2.473,3.253"
                                                transform="translate(-11029 -2977.398)" fill="#fff" />
                                            <path id="Path_11581" data-name="Path 11581"
                                                d="M256,249.885a7.147,7.147,0,0,1-5.631,2.125q-122.37-.047-244.739,0A7.135,7.135,0,0,1,0,249.885v-3.992a7.066,7.066,0,0,1,5.631-2.111c16.832.052,33.664.031,50.5.025,3.341,0,3.357-.033,3.391-3.307.1-9.561.277-19.121.255-28.682-.005-2.355.844-3,3.055-2.973q11,.137,22,0c2.16-.027,2.91.685,2.887,2.879-.1,9.563-.054,19.127-.056,28.691,0,3.385.005,3.393,3.474,3.393q79.369,0,158.737-.024c2.35,0,4.485.25,6.131,2.109Z"
                                                transform="translate(-11029 -3024.812)" fill="#fff" />
                                            <path id="Path_11582" data-name="Path 11582"
                                                d="M207.649,51.679c4.245-2.413,8.48-4.847,12.744-7.227,1.151-.643,2.077.207,2.992.73q32.521,18.608,65.031,37.237c3.323,1.9,6.615,3.865,9.976,5.7a3.383,3.383,0,0,1,2.013,3.347q-.06,44.034,0,88.069c0,1.949-.691,2.631-2.621,2.625q-22.5-.068-45,.013c-2.3.012-2.765-.967-2.759-3.01q.079-29.439.029-58.879c0-4.987-.965-5.937-6.007-5.941-5.583,0-11.166,0-16.749,0-3.245-.005-3.257-.016-3.259-3.357q-.009-19.46-.008-38.92c-.007-6.531-2.281-12.019-7.569-16.084-2.557-1.965-5.589-2.86-8.818-4.3"
                                                transform="translate(-11098.217 -2969.938)" fill="#fff" />
                                            <path id="Path_11583" data-name="Path 11583"
                                                d="M129.055,37.24c.563-1.143,1.593-1.412,2.426-1.89C151.264,24,171.091,12.733,190.817,1.289a7.31,7.31,0,0,1,8.283-.007q36.334,20.967,72.785,41.731c4.768,2.73,9.507,5.51,14.3,8.189a5.324,5.324,0,0,1,3.042,5.237c-.117,5.235-.025,10.474-.039,15.711-.007,2.789-.106,2.864-2.535,1.477q-23.2-13.246-46.386-26.528c-13.8-7.9-27.615-15.762-41.352-23.762-2.752-1.6-5.009-1.751-7.823-.049-7.333,4.435-14.857,8.556-22.269,12.865a10.289,10.289,0,0,1-5.423,1.51c-10.578-.061-21.157-.023-31.735-.038a4.309,4.309,0,0,1-2.61-.385"
                                                transform="translate(-11072.019 -2955.197)" fill="#fff" />
                                            <path id="Path_11584" data-name="Path 11584"
                                                d="M238.915,190.449q0,13.46-.006,26.919c-.007,3.209-.181,3.367-3.408,3.37-12.487.009-24.973-.058-37.459.053-2.585.023-3.275-.9-3.233-3.344.125-7.226.115-14.456.005-21.683-.036-2.337.674-3.335,3.121-3.2a25.452,25.452,0,0,0,6.718-.259c9.09-1.92,14.868-9.087,15.089-18.811q.124-5.481-.005-10.965c-.045-1.816.591-2.511,2.445-2.475,4.577.089,9.16.141,13.733-.021,2.328-.082,3.051.759,3.032,3-.079,9.138-.033,18.277-.032,27.416m-4.6.121h.012c0-.991.043-1.984-.009-2.972-.113-2.157-1.21-3.385-3.447-3.351a3.041,3.041,0,0,0-3.28,3.263c-.081,1.9-.1,3.8.005,5.7a3.145,3.145,0,0,0,3.313,3.288c2.045.027,3.191-1.187,3.391-3.2.089-.9.015-1.815.015-2.723"
                                                transform="translate(-11093.936 -3008.541)" fill="#fff" />
                                            <path id="Path_11585" data-name="Path 11585"
                                                d="M142.228,222.842c0-3.82.063-7.641-.027-11.459-.043-1.811.614-2.535,2.45-2.523q11.731.077,23.463.006c1.671-.008,2.413.621,2.4,2.345q-.061,11.708,0,23.417c.009,1.68-.641,2.4-2.356,2.392q-11.731-.057-23.462.006c-1.789.011-2.543-.619-2.5-2.475.093-3.9.029-7.805.028-11.708"
                                                transform="translate(-11076.399 -3024.817)" fill="#fff" />
                                            <path id="Path_11586" data-name="Path 11586"
                                                d="M89.676,133.652H86.85a2.556,2.556,0,0,1-2.213-3.833l1.413-2.447a2.554,2.554,0,0,1,4.427,0l1.413,2.447a2.556,2.556,0,0,1-2.213,3.833"
                                                transform="translate(-11057.097 -2997.228)" fill="#fff" />
                                        </g>
                                    </svg>

                                </div>
                                <div class="des_info">
                                    <div class="title-text">
                                        {{ __('Properties For Sell') }}
                                    </div>
                                    <div class="data text3">
                                        {{ $list['total_sell_property'] ? $list['total_sell_property'] : 0 }}
                                    </div>
                                </div>

                            </div>
                        </a>

                    </div>

                    <div class="col-md-6">
                        <a href="{{ url('property') . '?type=1' }}">

                            <div class="das-card">
                                <div class="des_icon bg4">
                                    <svg xmlns="http://www.w3.org/2000/svg" width="40.058" height="40"
                                        viewBox="0 0 256.058 256">
                                        <g id="rent_home" transform="translate(11385.056 2992)">
                                            <rect id="Rectangle_1003" data-name="Rectangle 1003" width="128"
                                                height="128" transform="translate(-11385 -2992)" fill="none" />
                                            <g id="rent_home-2" data-name="rent_home"
                                                transform="translate(-11385.057 -2992)">
                                                <path id="Path_11575" data-name="Path 11575"
                                                    d="M0,187.121q75.337-.012,150.674-.024,50.474-.006,100.949,0c.916,0,1.833.011,2.747.051a1.519,1.519,0,0,1,1.67,1.723c-.015.583.016,1.166.016,1.749q0,40.1,0,80.209c0,3.412-.012,3.423-3.448,3.423q-124.937,0-249.874-.005c-.911,0-1.822-.109-2.733-.167v-86.96m157.222,41.436c-.934-.033-1.225-.823-1.681-1.363-2.957-3.495-5.889-7.011-8.833-10.516-5.377-6.4-5.377-6.363-13.83-6.046-1.7.064-2.352.636-2.345,2.36q.066,18.106,0,36.213c-.008,1.794.739,2.312,2.4,2.257,2.578-.085,5.169-.146,7.74.015,2.278.144,2.863-.837,2.807-2.932-.113-4.242-.045-8.49-.019-12.736,0-.8-.313-1.92.535-2.285.944-.406,1.336.741,1.833,1.327,2.908,3.426,5.782,6.882,8.66,10.335,5.441,6.528,5.439,6.53,13.954,6.253a2.21,2.21,0,0,1,.249,0c1.458.125,2.114-.469,2.11-2q-.048-18.356,0-36.712c0-1.511-.636-2.086-2.1-2.066-3,.042-5.995.059-8.99-.006-1.693-.037-2.119.8-2.1,2.317.053,4.328.037,8.658,0,12.986-.007.865.3,1.817-.386,2.605M37.639,230.848v17.977a2.224,2.224,0,0,1,0,.25c-.178,1.658.426,2.451,2.232,2.39,2.992-.1,5.992-.068,8.987-.015,1.48.027,2.145-.571,2.112-2.058-.038-1.747-.06-3.5.024-5.242.056-1.154-.476-2.723,1.3-3.073,1.6-.316,3.083-.175,4.115,1.5,1.525,2.479,3.257,4.829,4.847,7.27A3.046,3.046,0,0,0,64.1,251.46q5.117-.107,10.237,0c2.02.039,1.837-.728.941-2.015-2-2.868-3.9-5.8-5.941-8.64-1-1.4-.787-2.177.614-3.2a14.125,14.125,0,0,0,5.49-15.663c-1.681-6.513-7.6-10.947-15.4-11.177-6.653-.2-13.316-.038-19.972-.126-1.842-.024-2.481.65-2.456,2.486.081,5.908.03,11.818.029,17.727m48.5.1c0,6.078.014,12.155-.011,18.233-.005,1.315.167,2.27,1.845,2.265q15.236-.05,30.471-.007c1.27,0,1.816-.554,1.8-1.807-.028-1.748-.116-3.506.028-5.243.184-2.216-.724-2.908-2.881-2.864-5.242.107-10.489-.006-15.734.024-2.385.014-2.3-1.564-2.316-3.229s.157-2.966,2.363-2.885c2.827.1,5.662.074,8.491.009,7.872-.18,6.494,1.534,6.685-6.942.043-1.881-.768-2.48-2.538-2.452-4,.064-7.993-.025-11.989.031-1.986.027-3.064-.493-3.055-2.809.008-2.251.906-2.861,2.993-2.819,4.91.1,9.825-.018,14.735.053,1.735.025,2.415-.624,2.32-2.345a38.679,38.679,0,0,1,.006-4.992c.153-2.039-.794-2.552-2.663-2.54q-13.987.089-27.974,0c-1.927-.013-2.645.6-2.611,2.588.1,5.909.036,11.822.037,17.733m112.4-20.29c-5.493,0-10.987.058-16.479-.031-1.97-.032-2.7.712-2.585,2.64.111,1.908.058,3.828.023,5.741-.025,1.371.573,1.955,1.951,1.927,2.329-.048,4.67.122,6.988-.043,2.376-.17,3.2.66,3.161,3.089-.125,8.155.016,16.313-.087,24.469-.028,2.2.5,3.218,2.91,3.03a50.645,50.645,0,0,1,7.484,0c2.318.164,3.026-.694,3-2.978-.107-8.238.008-16.479-.072-24.718-.021-2.14.671-3.025,2.883-2.886,2.4.152,4.829-.049,7.238.059,1.782.079,2.37-.664,2.278-2.356a40.011,40.011,0,0,1,.007-5.24c.162-2.078-.66-2.775-2.716-2.735-5.325.1-10.653.035-15.98.037"
                                                    transform="translate(0 -62.178)" fill="#fff" />
                                                <path id="Path_11576" data-name="Path 11576"
                                                    d="M211.557,0c.023,18.734.081,37.468.023,56.2a6.171,6.171,0,0,0,2.51,5.506c10.209,8.027,20.262,16.252,30.463,24.288,1.924,1.516,2.025,2.576.431,4.346-2.114,2.346-4.061,4.855-5.942,7.4-1.3,1.761-2.382,2.094-4.19.517-3.323-2.9-6.848-5.564-10.308-8.3-.487-.386-.981-1.138-1.7-.688-.52.326-.323,1.07-.325,1.639-.013,4.579.026,9.159-.029,13.738-.029,2.5-.46,2.737-2.558,1.48q-36.522-21.895-73.046-43.787a3.584,3.584,0,0,1-2-3.621c.116-2.659-.019-5.329.045-7.991.035-1.474-.493-2.116-2.026-2.09-3.579.062-7.161.05-10.741.006-1.4-.017-1.926.586-1.9,1.952.048,2.747-.062,5.5.036,8.242a3.425,3.425,0,0,1-1.879,3.44Q91.743,84.156,55.11,106.106c-2,1.2-2.386.983-2.418-1.4-.059-4.329.005-8.66-.046-12.989-.011-.853.5-2.056-.491-2.489-.791-.345-1.417.669-2.048,1.169-3.392,2.689-6.809,5.35-10.124,8.133-1.425,1.2-2.362,1.068-3.468-.381-2.12-2.779-4.288-5.53-6.582-8.165-1.385-1.59-1.117-2.5.479-3.776Q60.184,62.453,89.867,38.584c15-12.031,30.039-24.022,44.972-36.141,2.058-1.67,3.352-1.791,5.472-.049,10.354,8.511,20.858,16.838,31.314,25.225.767.616,1.564,1.2,2.949,2.25V0Z"
                                                    transform="translate(-9.649)" fill="#fff" />
                                                <path id="Path_11577" data-name="Path 11577"
                                                    d="M141.29,368.835q-48.586,0-97.172,0c-3.957,0-3.959-.006-3.961-3.974,0-3.081.075-6.165-.024-9.242-.061-1.878.749-2.5,2.518-2.476,3.663.057,7.33-.073,10.99.042,2.091.065,2.816-.759,2.741-2.785-.1-2.827.007-5.661-.021-8.492-.017-1.627.571-2.546,2.348-2.362a14.555,14.555,0,0,0,1.5,0H222.326c3.859,0,3.862,0,3.872,3.831.006,2.249.1,4.5-.026,6.743-.128,2.219.6,3.181,2.969,3.071,3.49-.162,6.994.026,10.489-.063,1.98-.051,2.882.576,2.8,2.711-.134,3.576-.08,7.161-.023,10.74.026,1.59-.6,2.321-2.2,2.247-.831-.039-1.665,0-2.5,0H141.29"
                                                    transform="translate(-13.336 -112.836)" fill="#fff" />
                                                <path id="Path_11578" data-name="Path 11578"
                                                    d="M102.047,149.565c.235-1.072,1.04-1.265,1.648-1.632q23.94-14.47,47.9-28.9c.751-.452,1.544-1.4,2.439-.929.926.488.453,1.658.477,2.525.059,2.08.067,4.164.007,6.243-.041,1.422.385,2.176,1.968,2.148q5.369-.093,10.741,0c1.588.028,2-.738,1.962-2.154-.057-2.33.049-4.664-.028-6.993-.069-2.086.647-2.275,2.307-1.267,8.18,4.975,16.39,9.9,24.588,14.842q11.977,7.224,23.944,14.46c.61.37,1.41.567,1.682,1.656Z"
                                                    transform="translate(-33.914 -39.208)" fill="#fff" />
                                                <path id="Path_11579" data-name="Path 11579"
                                                    d="M76.344,242.274c0-5.4.735-5.885,7.2-4.706a4.89,4.89,0,0,1,3.931,6.7,4.32,4.32,0,0,1-2.663,2.77,10.8,10.8,0,0,1-2.161.553c-5.755.894-6.307.421-6.307-5.319"
                                                    transform="translate(-25.372 -78.777)" fill="#fff" />
                                            </g>
                                        </g>
                                    </svg>

                                </div>
                                <div class="des_info">
                                    <div class="title-text">
                                        {{ __('Properties For Rant') }}
                                    </div>
                                    <div class="data text4">
                                        {{ $list['total_rant_property'] ? $list['total_rant_property'] : 0 }}
                                    </div>
                                </div>

                            </div>
                        </a>

                    </div>
                    <div class="col-sm-12">
                        <div class="card map_title h-100">
                            <div class="card-header border-0 pb-0">
                                <h4>{{ __('Luxurious Properties') }}</h4>
                            </div>
                            <div class="card-body">
                                <div id="world-map" style="width: 100%; height: 700px"></div>
                            </div>
                        </div>

                    </div>

                </div>

            </div>

            <div class="col-md-6">

                <div class="card most_view">
                    <div class="card-header border-0 pb-0">
                        <h4>{{ __('Most Viewed Properties') }}</h4>

                    </div>
                    <div class="card-body">
                        @foreach ($properties_data as $key => $value)
                            <div class="d-flex align-items-center property_card mt-2">
                                <div class="property_img">
                                    <img src="{{ $value->title_image ? $value->title_image : url('assets/images/logo/favicon.png') }}"
                                        width="75" alt="">
                                </div>
                                <div>
                                    <h5 class="mb-0">{{ $value->title }}</h5>
                                    <div class="font-w600 mb-0"><i class="bi bi-geo-alt"></i>&nbsp;{{ $value->city }}
                                    </div>
                                    <div class="font-w600 mb-0">
                                        &nbsp;{{ $settings['currency_symbol'] }}&nbsp;{{ $value->price }}
                                    </div>

                                </div>
                                <div class="ms-auto">
                                    <div class="view">
                                        <i class="fbi bi-eye-fill"></i>
                                        <span class="number">{{ $value->total_click }}</span>
                                    </div>
                                </div>

                            </div>
                        @endforeach

                    </div>

                </div>
            </div>
        </div>

        <input type="hidden" name="" value="{{ $settings['currency_symbol'] }}" id="currency_symbol">
        <input type="hidden" name="map_data" id="map_data" value="{{ $properties }}">


        </div>
    </section>
@endsection
@section('script')
    <script src="{{ url('assets/js/query-jvectormap-world-mill-en.js') }}"></script>


    <script>
        var colors = ['red', 'purple', 'black', 'pink', 'orange'];

        $(document).ready(function() {
            function getColorForCity(city) {
                var index = city.charCodeAt(0) % colors.length;
                return colors[index];
            }

            var currency_symbol = $('#currency_symbol').val();
            var mapData = JSON.parse($('#map_data').val());

            var default_image = window.location.origin + '/assets/images/logo/favicon.png';

            var markerValues = mapData.map(function(property, index) {
                return {
                    latLng: [parseFloat(property.latitude), parseFloat(property.longitude)],
                    name: property.city,
                    label: property.city,
                    style: {
                        fill: '#087C7C',
                        stroke: '#087C7C'
                    },
                    card: {
                        content: '<div class="card_map">' +
                            '<div class="img"><img src="' + (property.title_image == '' ? default_image :
                                property.title_image) +
                            '" height="100%" width="100%"/></div>' +
                            '<div class="textBox">' +
                            '<div class="textContent">' +
                            '<p class="title">' + property.title + '</p>' +
                            '</div>' +
                            ' <span class="city"><i class="bi bi-geo-alt"></i>' + property.city +
                            '</span></br>' +
                            ' <span class="price">' + currency_symbol +
                            property.price +
                            '</span>' +
                            '</div>' +
                            '</div>'
                    }
                };
            });

            $('#world-map').vectorMap({
                map: 'world_mill',
                // scaleColors: ['#116D6E', '#116D6E'],
                backgroundColor: '#fffff',

                markerStyle: {
                    initial: {
                        strokeWidth: 1,
                        stroke: '#383f47',
                        fillOpacity: 1,
                        r: 8,

                    },
                    onMarkerLabelShow: function(event, label, index) {
                        // Add custom CSS classes to the label element
                        label.addClass('custom-marker-label');
                    },

                },

                markers: markerValues,
                series: {
                    markers: [{
                        // attribute: 'fill',
                        scale: {}, // Empty scale object to be populated dynamically
                        values: mapData.map(function(property) {
                            return property.city;
                        })
                    }]
                },
                onMarkerTipShow: function(event, label, index) {
                    var cardContent = markerValues[index].card.content;
                    label.html(cardContent);
                }
            });

        });
    </script>
@endsection
