# Core v5.4.2
**Release Date:** August 9, 2025  
**Tags:** FEATURE ENHANCEMENTS, ADMIN IMPROVEMENTS, USER MANAGEMENT

## New Features

### CSV Import/Export for User Management
- **Added** bulk user import functionality via CSV file upload
- **Added** user export to CSV for data backup and migration
- **Implemented** comprehensive CSV validation and error reporting
- **Added** downloadable CSV template with example data
- **Support** for all user fields including profile and social data

### Exchange Market Fee Management
- **Added** ability to edit taker and maker fees for spot markets
- **Added** editable fields for market trending and hot flags
- **Added** precision configuration for price and amount decimals
- **Enhanced** exchange market management interface similar to ecosystem markets

## Feature Details

### User CSV Import Features
- **Validation** for required fields (email, firstName, lastName)
- **Duplicate detection** prevents creating users with existing emails
- **Configurable default password** for imported users without passwords
- **Optional welcome email** sending to newly imported users
- **Detailed error reporting** with row numbers and specific error messages
- **Support for profile data** including bio, location, and social media links
- **Flexible boolean parsing** accepts true/false, yes/no, 1/0 formats
- **Batch processing** with transaction support for data integrity

### User CSV Export Features
- **Export filters** by user status (ACTIVE, INACTIVE, BANNED, SUSPENDED)
- **Optional password export** (encrypted) for migration purposes
- **Complete data export** including all profile and social fields
- **Auto-generated filename** with current date
- **CSV format** compatible with import template

### Exchange Market Enhancements
- **Editable fee structure**:
  - Taker fee percentage
  - Maker fee percentage
- **Market configuration**:
  - Currency and pair editing
  - Trending and hot market flags
  - Price and amount precision settings
- **API improvements**:
  - Fixed permission scope from ecosystem to exchange
  - Updated operation IDs and tags for proper categorization

## Technical Details

### Files Added
- `backend/src/api/admin/crm/user/import.post.ts` - CSV import endpoint
- `backend/src/api/admin/crm/user/export-csv.get.ts` - CSV export endpoint
- `frontend/public/templates/users_import_template.csv` - Sample CSV template

### Files Modified
- `frontend/app/[locale]/(dashboard)/admin/crm/user/page.tsx` - Added import/export UI
- `frontend/app/[locale]/(dashboard)/admin/finance/exchange/[id]/market/columns.tsx` - Enhanced market fee editing
- `backend/src/api/admin/finance/exchange/market/[id]/index.put.ts` - Fixed permissions and expanded update fields
- `backend/src/api/admin/finance/exchange/market/utils.ts` - Added currency/pair to update schema

### Dependencies Added
- `csv-parse` - For parsing CSV files during import
- `csv-stringify` - For generating CSV files during export

## CSV Import Format

### Required Fields
- `email` - User's email address (must be unique)
- `firstName` - User's first name
- `lastName` - User's last name

### Optional Fields
- `password` - User password (uses default if not provided)
- `phone` - Phone number
- `status` - ACTIVE, INACTIVE, BANNED, or SUSPENDED
- `emailVerified` - Email verification status
- `twoFactor` - Two-factor authentication enabled
- `roleId` - User role identifier
- `avatar` - Avatar URL

### Profile Fields
- `bio` - User biography
- `address` - Street address
- `city` - City name
- `country` - Country name
- `zip` - Postal code

### Social Media Fields
- `facebook` - Facebook profile URL
- `twitter` - Twitter profile URL
- `instagram` - Instagram profile URL
- `github` - GitHub profile URL
- `dribbble` - Dribbble profile URL
- `gitlab` - GitLab profile URL

## Impact
- **Administrators** can now bulk import users from external systems
- **Data migration** simplified with CSV export/import functionality
- **Exchange operators** have full control over market fee structures
- **Improved efficiency** for managing large user bases
- **Better alignment** between exchange and ecosystem market management

## Permissions
New permissions added for granular control:
- `import.user` - Required to import users from CSV
- `export.user` - Required to export users to CSV

These permissions are separate from the standard `create.user` and `view.user` permissions, allowing administrators to control who can perform bulk operations.

## Security Considerations
- Passwords are hashed using bcrypt before storage
- CSV imports validate all data before database insertion
- Import/Export require specific admin permissions (`import.user` and `export.user`)
- Import and Export buttons are only visible to users with appropriate permissions
- File upload size limits prevent abuse
- Detailed audit trail for bulk operations

## Known Limitations
- CSV files must be UTF-8 encoded
- Maximum file size depends on server configuration
- Welcome emails require email service configuration
- Large imports may take several seconds to process

## Migration Guide
For users upgrading from previous versions:
1. Run database migrations if any schema changes
2. Run the permissions seeder to add new permissions: `npm run seed:permissions`
3. Update frontend and backend dependencies with `pnpm install`
4. Restart both frontend and backend services
5. Assign `import.user` and `export.user` permissions to appropriate roles
6. Test import functionality with the provided template

## Support
For issues or questions regarding these features, please refer to the documentation or contact support.