# Core v5.3.3
**Release Date:** January 17, 2025  
**Tags:** INVESTMENT, ADMIN, UI/UX, DATATABLE, MULTISELECT, KYC, TRADING, ORDERBOOK, FINANCE, SPOT

## Fixed
- Investment plan creation/editing now properly supports duration selection through multiselect dropdown
- DataTable modal cancel button no longer causes page to become unresponsive
- Multiselect component displaying "undefined, undefined" for investment plan durations
- Number input fields in DataTable modals having inconsistent padding styling
- Backend investment plan endpoints now handle both legacy and new duration data formats
- KYC application submission now redirects to correct application page using applicationId instead of levelId
- KYC application submission error handling now properly displays error messages to users
- KYC levels JSON parsing now has proper error handling to prevent crashes from malformed data
- KYC admin application search filter now properly handles null/undefined values with optional chaining
- KYC backend number validation now properly converts string numbers to numeric values
- KYC phone number validation regex now allows dots (.) in phone numbers
- KYC admin application drawer state now properly resets when opening new applications
- KYC application status updates now prevent race conditions with proper loading state management
- KYC admin image viewer now supports ESC key to close and handles image load errors gracefully
- Trading orderbook now shows multiple orders instead of single aggregated order per price level
- Trading orderbook default limit increased from 15 to 50 orders per side
- Trading orderbook aggregation level changed from 0.1 to 0.01 for more granular price display
- Trading orderbook WebSocket handler now properly handles and limits orderbook data
- Finance deposit page React error #31 "Objects are not valid as a React child" causing page crashes
- Finance deposit store JSON parsing errors now properly handle malformed data with fallback values
- Finance deposit methods rendering now includes comprehensive object safety checks
- Finance deposit network display functions now include proper error handling and type checking
- SPOT deposit transaction hash input field missing from deposit flow
- SPOT deposit countdown timer not working properly due to hardcoded display
- SPOT deposit monitoring step missing after transaction hash submission
- SPOT deposit step progression not advancing to monitoring screen

## Added
- SPOT deposit transaction hash input field with comprehensive validation and instructions
- SPOT deposit monitoring step (step 5) showing transaction verification progress
- SPOT deposit countdown timer functionality with proper start time initialization
- Duration selection functionality to investment plan creation and editing forms
- Proper data transformation for investment duration objects in multiselect components
- Support for API-based multiselect options with proper label formatting
- Enhanced investment plan form with searchable duration multiselect dropdown

## Enhanced
- Investment plan admin interface now allows linking multiple durations to plans
- DataTable cancel button properly handles unsaved changes with confirmation dialog
- Multiselect component correctly formats duration display as "1 WEEK", "1 DAY", etc.
- Investment duration menu terminology changed from "Investment Terms" to "Investment Durations"
- Form validation and data processing for investment plan duration relationships
- DataTable drawer form state management improved for better user experience
- KYC admin application search now includes lastName in search results
- KYC admin drawer state management improved with proper cleanup and initialization

## Removed
- Hardcoded padding-left styling from number input fields in DataTable forms
- DrawerClose component usage that bypassed proper modal close handling 